/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.basic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.protocol.tri.rest.RestConstants;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.AnnotationBaseArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.stub.annotations.GRequest;

@Activate
public class GRequestArgumentResolver
implements AnnotationBaseArgumentResolver<GRequest> {
    @Override
    public Class<GRequest> accept() {
        return GRequest.class;
    }

    @Override
    public NamedValueMeta getNamedValueMeta(ParameterMeta parameter, AnnotationMeta<Annotation> annotation) {
        return new NamedValueMeta().setParamType(ParamType.Body);
    }

    @Override
    public Object resolve(ParameterMeta parameter, AnnotationMeta<GRequest> annotation, HttpRequest request, HttpResponse response) {
        HttpMessageDecoder decoder = (HttpMessageDecoder)request.attribute(RestConstants.BODY_DECODER_ATTRIBUTE);
        if (decoder == null) {
            return null;
        }
        HashMap value = new HashMap();
        Map variableMap = (Map)request.attribute("org.springframework.web.servlet.HandlerMapping.uriTemplateVariables");
        if (variableMap != null) {
            value.putAll(variableMap);
        }
        InputStream is = request.inputStream();
        try {
            Object body;
            int available = is.available();
            if (available > 0 && (body = decoder.decode(is, Object.class, request.charsetOrDefault())) instanceof Map) {
                Map bodyMap = (Map)body;
                String key = annotation.getValue();
                if ("*".equals(key) || key.isEmpty()) {
                    value.putAll(bodyMap);
                } else {
                    value.put(key, bodyMap.get(key));
                }
            }
        }
        catch (IOException e) {
            throw new DecodeException("Error reading input", (Throwable)e);
        }
        return decoder.decode((InputStream)new ByteArrayInputStream(JsonUtils.toJson(value).getBytes(StandardCharsets.UTF_8)), parameter.getType(), StandardCharsets.UTF_8);
    }
}

