/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.basic;

import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.rest.Param;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.AbstractArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.basic.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestUtils;

@Activate(order=2147473647)
public class FallbackArgumentResolver
extends AbstractArgumentResolver {
    @Override
    public boolean accept(ParameterMeta param) {
        return param.getToolKit().getDialect() == 0;
    }

    @Override
    protected NamedValueMeta createNamedValueMeta(ParameterMeta param) {
        boolean noBodyParam = true;
        int paramCount = -1;
        if (param instanceof MethodParameterMeta) {
            ParameterMeta[] paramMetas;
            MethodMeta methodMeta = ((MethodParameterMeta)param).getMethodMeta();
            for (ParameterMeta paramMeta : paramMetas = methodMeta.getParameters()) {
                AnnotationMeta<Param> anno = paramMeta.findAnnotation(Param.class);
                if (anno == null || anno.getAnnotation().type() != ParamType.Body) continue;
                noBodyParam = false;
                break;
            }
            paramCount = methodMeta.getMethodDescriptor().getRpcType() != MethodDescriptor.RpcType.UNARY ? 1 : paramMetas.length;
        } else if (param instanceof MethodMeta.StreamParameterMeta) {
            paramCount = 1;
            noBodyParam = false;
        }
        return new FallbackNamedValueMeta(param.isAnnotated(Annotations.Nonnull), noBodyParam, paramCount);
    }

    @Override
    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return this.doResolveValue(meta, true, request, response);
    }

    @Override
    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return this.doResolveValue(meta, false, request, response);
    }

    protected Object doResolveValue(NamedValueMeta meta, boolean single, HttpRequest request, HttpResponse response) {
        FallbackNamedValueMeta fm = (FallbackNamedValueMeta)meta;
        if (HttpMethods.supportBody((String)request.method())) {
            Object body2;
            if (fm.paramCount == 1) {
                try {
                    body2 = RequestUtils.decodeBody(request, meta.genericType());
                    if (body2 != null) {
                        if (body2 != "") {
                            return body2;
                        }
                        Object value = single ? request.parameter(meta.name()) : request.parameterValues(meta.name());
                        return value == null ? body2 : value;
                    }
                }
                catch (DecodeException body2) {
                    // empty catch block
                }
            }
            if (fm.noBodyParam) {
                Object value;
                body2 = RequestUtils.decodeBodyAsObject(request);
                if (body2 instanceof List) {
                    List list = (List)body2;
                    if (list.size() == fm.paramCount) {
                        return list.get(meta.parameter().getIndex());
                    }
                } else if (body2 instanceof Map && (value = ((Map)body2).get(meta.name())) != null) {
                    return value;
                }
            }
        }
        if (meta.parameter().isStream()) {
            return null;
        }
        if (single) {
            if (Map.class.isAssignableFrom(meta.type())) {
                return RequestUtils.getParametersMap(request);
            }
            String value = request.parameter(meta.name());
            if (meta.parameter().isSimple() || RestUtils.isMaybeJSONObject(value)) {
                return value;
            }
            return meta.parameter().bind(request, response);
        }
        return request.parameterValues(meta.name());
    }

    @Override
    protected Object resolveMapValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return this.resolveValue(meta, request, response);
    }

    private static final class FallbackNamedValueMeta
    extends NamedValueMeta {
        private final boolean noBodyParam;
        private final int paramCount;

        FallbackNamedValueMeta(boolean required, boolean noBodyParam, int paramCount) {
            super(null, required);
            this.noBodyParam = noBodyParam;
            this.paramCount = paramCount;
        }
    }
}

