/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.rpc.protocol.tri.rest.cors.CorsUtils;

public class CorsMeta {
    private final String[] allowedOrigins;
    private final Pattern[] allowedOriginsPatterns;
    private final String[] allowedMethods;
    private final String[] allowedHeaders;
    private final String[] exposedHeaders;
    private final Boolean allowCredentials;
    private final Long maxAge;

    private CorsMeta(String[] allowedOrigins, Pattern[] allowedOriginsPatterns, String[] allowedMethods, String[] allowedHeaders, String[] exposedHeaders, Boolean allowCredentials, Long maxAge) {
        this.allowedOrigins = allowedOrigins;
        this.allowedOriginsPatterns = allowedOriginsPatterns;
        this.allowedMethods = allowedMethods;
        this.allowedHeaders = allowedHeaders;
        this.exposedHeaders = exposedHeaders;
        this.allowCredentials = allowCredentials;
        this.maxAge = maxAge;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CorsMeta combine(CorsMeta source, CorsMeta other) {
        return source == null || source.isEmpty() ? (other == null || other.isEmpty() ? null : other.applyDefault()) : source.combine(other).applyDefault();
    }

    public String[] getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public Pattern[] getAllowedOriginsPatterns() {
        return this.allowedOriginsPatterns;
    }

    public String[] getAllowedMethods() {
        return this.allowedMethods;
    }

    public String[] getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public String[] getExposedHeaders() {
        return this.exposedHeaders;
    }

    public Boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public boolean isEmpty() {
        return this.allowedOrigins.length == 0 && this.allowedMethods.length == 0 && this.allowedHeaders.length == 0 && this.exposedHeaders.length == 0 && this.allowCredentials == null && this.maxAge == null;
    }

    public CorsMeta applyDefault() {
        String[] allowedOriginArray = null;
        Pattern[] allowedOriginPatternArray = null;
        if (this.allowedOrigins.length == 0) {
            allowedOriginArray = new String[]{"*"};
            allowedOriginPatternArray = new Pattern[]{null};
        }
        String[] allowedMethodArray = null;
        if (this.allowedMethods.length == 0) {
            allowedMethodArray = new String[]{HttpMethods.GET.name(), HttpMethods.HEAD.name(), HttpMethods.POST.name()};
        }
        String[] allowedHeaderArray = null;
        if (this.allowedHeaders.length == 0) {
            allowedHeaderArray = new String[]{"*"};
        }
        Long maxAgeValue = null;
        if (this.maxAge == null) {
            maxAgeValue = 1800L;
        }
        if (allowedOriginArray == null && allowedMethodArray == null && allowedHeaderArray == null && maxAgeValue == null) {
            return this;
        }
        return new CorsMeta(allowedOriginArray == null ? this.allowedOrigins : allowedOriginArray, allowedOriginPatternArray == null ? this.allowedOriginsPatterns : allowedOriginPatternArray, allowedMethodArray == null ? this.allowedMethods : allowedMethodArray, allowedHeaderArray == null ? this.allowedHeaders : allowedHeaderArray, this.exposedHeaders, this.allowCredentials, maxAgeValue);
    }

    public CorsMeta combine(CorsMeta other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        return new CorsMeta(CorsMeta.combine(this.allowedOrigins, other.allowedOrigins), CorsMeta.merge(this.allowedOriginsPatterns, other.allowedOriginsPatterns).toArray(new Pattern[0]), CorsMeta.combine(this.allowedMethods, other.allowedMethods), CorsMeta.combine(this.allowedHeaders, other.allowedHeaders), CorsMeta.combine(this.exposedHeaders, other.exposedHeaders), other.allowCredentials == null ? this.allowCredentials : other.allowCredentials, other.maxAge == null ? this.maxAge : other.maxAge);
    }

    private static String[] combine(String[] source, String[] other) {
        if (other.length == 0) {
            return source;
        }
        if (source.length == 0 || source[0].equals("*") || other[0].equals("*")) {
            return other;
        }
        return CorsMeta.merge(source, other).toArray(StringUtils.EMPTY_STRING_ARRAY);
    }

    private static <T> Set<T> merge(T[] source, T[] other) {
        int size = source.length + other.length;
        if (size == 0) {
            return Collections.emptySet();
        }
        Set merged = CollectionUtils.newLinkedHashSet((int)size);
        Collections.addAll(merged, source);
        Collections.addAll(merged, other);
        return merged;
    }

    public String toString() {
        return "CorsMeta{allowedOrigins=" + Arrays.toString(this.allowedOrigins) + ", allowedOriginsPatterns=" + Arrays.toString(this.allowedOriginsPatterns) + ", allowedMethods=" + Arrays.toString(this.allowedMethods) + ", allowedHeaders=" + Arrays.toString(this.allowedHeaders) + ", exposedHeaders=" + Arrays.toString(this.exposedHeaders) + ", allowCredentials=" + this.allowCredentials + ", maxAge=" + this.maxAge + '}';
    }

    public static final class Builder {
        private static final Pattern PORTS_PATTERN = Pattern.compile("(.*):\\[(\\*|\\d+(,\\d+)*)]");
        private final Set<String> allowedOrigins = new LinkedHashSet<String>();
        private final Set<String> allowedMethods = new LinkedHashSet<String>();
        private final Set<String> allowedHeaders = new LinkedHashSet<String>();
        private final Set<String> exposedHeaders = new LinkedHashSet<String>();
        private Boolean allowCredentials;
        private Long maxAge;

        public Builder allowedOrigins(String ... origins) {
            Builder.addValues(this.allowedOrigins, CorsUtils::formatOrigin, origins);
            return this;
        }

        public Builder allowedMethods(String ... methods) {
            Builder.addValues(this.allowedMethods, v -> v.trim().toUpperCase(), methods);
            return this;
        }

        public Builder allowedHeaders(String ... headers) {
            Builder.addValues(this.allowedHeaders, String::trim, headers);
            return this;
        }

        public Builder exposedHeaders(String ... headers) {
            Builder.addValues(this.exposedHeaders, String::trim, headers);
            return this;
        }

        private static void addValues(Set<String> set, Function<String, String> fn, String ... values) {
            if (values == null || set.contains("*")) {
                return;
            }
            for (String value : values) {
                if (!StringUtils.isNotEmpty((String)value) || (value = fn.apply(value)).isEmpty()) continue;
                if ("*".equals(value)) {
                    set.clear();
                    set.add("*");
                    return;
                }
                set.add(value);
            }
        }

        private static Pattern initPattern(String patternValue) {
            String ports = null;
            Matcher matcher = PORTS_PATTERN.matcher(patternValue);
            if (matcher.matches()) {
                patternValue = matcher.group(1);
                ports = matcher.group(2);
            }
            patternValue = "\\Q" + patternValue + "\\E";
            patternValue = patternValue.replace("*", "\\E.*\\Q");
            if (ports != null) {
                patternValue = patternValue + ("*".equals(ports) ? "(:\\d+)?" : ":(" + ports.replace(',', '|') + ")");
            }
            return Pattern.compile(patternValue);
        }

        public Builder allowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        public Builder allowCredentials(String allowCredentials) {
            if ("true".equals(allowCredentials)) {
                this.allowCredentials = true;
            } else if ("false".equals(allowCredentials)) {
                this.allowCredentials = false;
            }
            return this;
        }

        public Builder maxAge(Long maxAge) {
            if (maxAge != null && maxAge > -1L) {
                this.maxAge = maxAge;
            }
            return this;
        }

        public CorsMeta build() {
            int len = this.allowedOrigins.size();
            String[] origins = new String[len];
            ArrayList<Pattern> originsPatterns = new ArrayList<Pattern>(len);
            int i = 0;
            for (String origin : this.allowedOrigins) {
                origins[i++] = origin;
                if ("*".equals(origin)) continue;
                originsPatterns.add(Builder.initPattern(origin));
            }
            return new CorsMeta(origins, originsPatterns.toArray(new Pattern[0]), this.allowedMethods.toArray(StringUtils.EMPTY_STRING_ARRAY), this.allowedHeaders.toArray(StringUtils.EMPTY_STRING_ARRAY), this.exposedHeaders.toArray(StringUtils.EMPTY_STRING_ARRAY), this.allowCredentials, this.maxAge);
        }
    }
}

