/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.remoting.http12.rest.Param;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RestToolKit;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public final class BeanMeta
extends ParameterMeta {
    private static final boolean HAS_PB = ClassUtils.hasProtobuf();
    private final Class<?> type;
    private final boolean flatten;
    private ConstructorMeta constructor;
    private Map<String, PropertyMeta> propertyMap;

    public BeanMeta(RestToolKit toolKit, String prefix, Class<?> type, boolean flatten) {
        super(toolKit, prefix, null);
        this.type = type;
        this.flatten = flatten;
    }

    public BeanMeta(RestToolKit toolKit, Class<?> type, boolean flatten) {
        this(toolKit, null, type, flatten);
    }

    public BeanMeta(RestToolKit toolKit, String prefix, Class<?> type) {
        this(toolKit, prefix, type, true);
    }

    public BeanMeta(RestToolKit toolKit, Class<?> type) {
        this(toolKit, null, type, true);
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Type getGenericType() {
        return this.type;
    }

    @Override
    protected AnnotatedElement getAnnotatedElement() {
        return this.type;
    }

    public ConstructorMeta getConstructor() {
        if (this.constructor == null) {
            this.constructor = BeanMeta.resolveConstructor(this.getToolKit(), this.getPrefix(), this.type);
        }
        return this.constructor;
    }

    public Collection<PropertyMeta> getProperties() {
        return this.getPropertiesMap().values();
    }

    public PropertyMeta getProperty(String name) {
        return this.getPropertiesMap().get(name);
    }

    private Map<String, PropertyMeta> getPropertiesMap() {
        Map<String, PropertyMeta> propertyMap = this.propertyMap;
        if (propertyMap == null) {
            propertyMap = new LinkedHashMap<String, PropertyMeta>();
            BeanMeta.resolvePropertyMap(this.getToolKit(), this.getPrefix(), this.type, this.flatten, propertyMap);
            this.propertyMap = propertyMap;
        }
        return propertyMap;
    }

    public Object newInstance() {
        return this.getConstructor().newInstance(new Object[0]);
    }

    public static ConstructorMeta resolveConstructor(RestToolKit toolKit, String prefix, Class<?> type) {
        Constructor<?>[] constructors = type.getConstructors();
        Constructor<?> ct = null;
        if (constructors.length == 1) {
            ct = constructors[0];
        } else {
            try {
                ct = type.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (ct == null) {
            throw new IllegalArgumentException("No available default constructor found in " + type);
        }
        return new ConstructorMeta(toolKit, prefix, ct);
    }

    public static void resolvePropertyMap(RestToolKit toolKit, String prefix, Class<?> type, boolean flatten, Map<String, PropertyMeta> propertyMap) {
        if (type == null || type == Object.class || TypeUtils.isSystemType(type)) {
            return;
        }
        Set pbFields = null;
        if (HAS_PB && Message.class.isAssignableFrom(type)) {
            try {
                Descriptors.Descriptor descriptor = (Descriptors.Descriptor)type.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
                pbFields = descriptor.getFields().stream().map(Descriptors.FieldDescriptor::getName).collect(Collectors.toSet());
            }
            catch (Exception descriptor) {
                // empty catch block
            }
        }
        LinkedHashSet<String> allNames = new LinkedHashSet<String>();
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
        if (pbFields == null) {
            for (Field field : type.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || field.isSynthetic()) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                fieldMap.put(field.getName(), field);
                allNames.add(field.getName());
            }
        }
        LinkedHashMap<String, Method> getMethodMap = new LinkedHashMap<String, Method>();
        LinkedHashMap<String, Method> setMethodMap = new LinkedHashMap<String, Method>();
        for (Method method : type.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if ((modifiers & 0x409) != 1) continue;
            String name = method.getName();
            int count = method.getParameterCount();
            if (count == 0) {
                Class<?> returnType = method.getReturnType();
                if (returnType == Void.TYPE) continue;
                if (name.length() > 3 && name.startsWith("get")) {
                    name = BeanMeta.toName(name, 3);
                    if (pbFields != null && !pbFields.contains(name)) continue;
                    getMethodMap.put(name, method);
                    allNames.add(name);
                    continue;
                }
                if (name.length() > 2 && name.startsWith("is") && returnType == Boolean.TYPE) {
                    if (pbFields != null && !pbFields.contains(name)) continue;
                    name = BeanMeta.toName(name, 2);
                    getMethodMap.put(name, method);
                    allNames.add(name);
                    continue;
                }
                if (!fieldMap.containsKey(name)) continue;
                getMethodMap.put(name, method);
                allNames.add(name);
                continue;
            }
            if (count != 1 || name.length() <= 3 || !name.startsWith("set")) continue;
            name = BeanMeta.toName(name, 3);
            setMethodMap.put(name, method);
            allNames.add(name);
        }
        for (String name : allNames) {
            Field field = (Field)fieldMap.get(name);
            Method getMethod = (Method)getMethodMap.get(name);
            Method setMethod = (Method)setMethodMap.get(name);
            int visibility = pbFields == null ? (setMethod == null ? 0 : 1) << 2 | (getMethod == null ? 0 : 1) << 1 | (field == null ? 0 : 1) : 3;
            PropertyMeta meta = new PropertyMeta(toolKit, field, getMethod, setMethod, prefix, name, visibility);
            propertyMap.put(meta.getName(), meta);
        }
        if (flatten) {
            BeanMeta.resolvePropertyMap(toolKit, prefix, type.getSuperclass(), true, propertyMap);
        }
    }

    private static String toName(String name, int index) {
        return Character.toLowerCase(name.charAt(index)) + name.substring(index + 1);
    }

    public static final class ConstructorMeta {
        private final Constructor<?> constructor;
        private final ConstructorParameterMeta[] parameters;

        ConstructorMeta(RestToolKit toolKit, String prefix, Constructor<?> constructor) {
            this.constructor = constructor;
            this.parameters = this.initParameters(toolKit, prefix, constructor);
        }

        public ConstructorParameterMeta[] getParameters() {
            return this.parameters;
        }

        private ConstructorParameterMeta[] initParameters(RestToolKit toolKit, String prefix, Constructor<?> ct) {
            Parameter[] cps = ct.getParameters();
            int len = cps.length;
            if (len == 0) {
                return new ConstructorParameterMeta[0];
            }
            String[] parameterNames = toolKit == null ? null : toolKit.getParameterNames(ct);
            ConstructorParameterMeta[] parameters = new ConstructorParameterMeta[len];
            for (int i = 0; i < len; ++i) {
                String parameterName = parameterNames == null ? null : parameterNames[i];
                parameters[i] = new ConstructorParameterMeta(toolKit, cps[i], prefix, parameterName);
            }
            return parameters;
        }

        public Object newInstance(Object ... args) {
            try {
                return this.constructor.newInstance(args);
            }
            catch (Throwable t) {
                throw ExceptionUtils.wrap(t);
            }
        }
    }

    public static final class PropertyMeta
    extends NestableParameterMeta {
        private final Field field;
        private final Method getMethod;
        private final Method setMethod;
        private final Parameter parameter;
        private final int visibility;

        PropertyMeta(RestToolKit toolKit, Field f, Method gm, Method sm, String prefix, String name, int visibility) {
            super(toolKit, prefix, name);
            this.visibility = visibility;
            this.field = f;
            this.getMethod = gm;
            this.setMethod = sm;
            this.parameter = this.setMethod == null ? null : this.setMethod.getParameters()[0];
            this.initNestedMeta();
        }

        public int getVisibility() {
            return this.visibility;
        }

        public Field getField() {
            return this.field;
        }

        public Method getGetMethod() {
            return this.getMethod;
        }

        public Method getSetMethod() {
            return this.setMethod;
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        @Override
        public Class<?> getType() {
            if (this.field != null) {
                return this.field.getType();
            }
            if (this.parameter != null) {
                return this.parameter.getType();
            }
            return this.getMethod.getReturnType();
        }

        @Override
        public Type getGenericType() {
            if (this.field != null) {
                return this.field.getGenericType();
            }
            if (this.parameter != null) {
                return this.parameter.getParameterizedType();
            }
            return this.getMethod.getGenericReturnType();
        }

        @Override
        protected AnnotatedElement getAnnotatedElement() {
            if (this.field != null) {
                return this.field;
            }
            if (this.parameter != null) {
                return this.parameter;
            }
            return this.getMethod;
        }

        @Override
        public List<? extends AnnotatedElement> getAnnotatedElements() {
            ArrayList<AnnotatedElement> elements = new ArrayList<AnnotatedElement>(3);
            if (this.field != null) {
                elements.add(this.field);
            }
            if (this.parameter != null) {
                elements.add(this.parameter);
            }
            if (this.getMethod != null) {
                elements.add(this.getMethod);
            }
            return elements;
        }

        @Override
        public Object getValue(Object bean) {
            if (this.getMethod != null) {
                try {
                    return this.getMethod.invoke(bean, new Object[0]);
                }
                catch (Throwable t) {
                    throw ExceptionUtils.wrap(t);
                }
            }
            if (this.field != null) {
                try {
                    return this.field.get(bean);
                }
                catch (Throwable t) {
                    throw ExceptionUtils.wrap(t);
                }
            }
            return null;
        }

        @Override
        public void setValue(Object bean, Object value) {
            if (this.setMethod != null) {
                try {
                    this.setMethod.invoke(bean, value);
                }
                catch (Throwable t) {
                    throw ExceptionUtils.wrap(t);
                }
            }
            if (this.field != null) {
                try {
                    this.field.set(bean, value);
                }
                catch (Throwable t) {
                    throw ExceptionUtils.wrap(t);
                }
            }
        }

        @Override
        public String getDescription() {
            return "PropertyMeta{" + (this.field == null ? (this.parameter == null ? this.getMethod : this.parameter) : this.field) + '}';
        }

        public boolean canSetValue() {
            return this.setMethod != null || this.field != null;
        }
    }

    private static final class NestedMeta
    extends NestableParameterMeta {
        private final Class<?> type;
        private final Type genericType;

        NestedMeta(RestToolKit toolKit, Type genericType) {
            super(toolKit, null, null);
            this.type = TypeUtils.getActualType(genericType);
            this.genericType = genericType;
            this.initNestedMeta();
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public Type getGenericType() {
            return this.genericType;
        }

        @Override
        protected AnnotatedElement getAnnotatedElement() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return "NestedParameter{" + (this.genericType == null ? this.type : this.genericType) + '}';
        }
    }

    public static abstract class NestableParameterMeta
    extends ParameterMeta {
        private NestableParameterMeta nestedMeta;
        private String finalName;

        public NestableParameterMeta(RestToolKit toolKit, String prefix, String name) {
            super(toolKit, prefix, name);
        }

        @Override
        @Nullable
        public final String getName() {
            String name = this.finalName;
            if (name == null) {
                AnnotationMeta<Param> param = this.findAnnotation(Param.class);
                if (param != null) {
                    name = param.getValue();
                }
                if (name == null || name.isEmpty()) {
                    name = super.getName();
                }
                this.finalName = name;
            }
            return name;
        }

        public Object getValue(Object bean) {
            return null;
        }

        public void setValue(Object bean, Object value) {
        }

        public final NestableParameterMeta getNestedMeta() {
            return this.nestedMeta;
        }

        protected final void initNestedMeta() {
            Type nestedType = null;
            Class<?> type = this.getType();
            if (Map.class.isAssignableFrom(type)) {
                nestedType = TypeUtils.getNestedGenericType(this.getGenericType(), 1);
            } else if (Collection.class.isAssignableFrom(type)) {
                nestedType = TypeUtils.getNestedGenericType(this.getGenericType(), 0);
            } else if (type.isArray()) {
                Type genericType = this.getGenericType();
                nestedType = genericType instanceof GenericArrayType ? ((GenericArrayType)genericType).getGenericComponentType() : type.getComponentType();
            }
            this.nestedMeta = nestedType == null ? null : new NestedMeta(this.getToolKit(), nestedType);
        }
    }

    public static final class ConstructorParameterMeta
    extends ParameterMeta {
        private final Parameter parameter;

        ConstructorParameterMeta(RestToolKit toolKit, Parameter parameter, String prefix, String name) {
            super(toolKit, prefix, name == null && parameter.isNamePresent() ? parameter.getName() : name);
            this.parameter = parameter;
        }

        @Override
        protected AnnotatedElement getAnnotatedElement() {
            return this.parameter;
        }

        @Override
        public Class<?> getType() {
            return this.parameter.getType();
        }

        @Override
        public Type getGenericType() {
            return this.parameter.getParameterizedType();
        }

        @Override
        public String getDescription() {
            return "ConstructorParameter{" + this.parameter + '}';
        }
    }
}

