/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathParser;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.PathSegment;
import org.apache.dubbo.rpc.protocol.tri.rest.util.KeyString;

public final class PathExpression
implements Comparable<PathExpression> {
    private final String path;
    private final PathSegment[] segments;

    private PathExpression(String path, PathSegment[] segments) {
        this.path = path;
        this.segments = segments;
    }

    public static PathExpression parse(@Nonnull String path) {
        return new PathExpression(path, PathParser.parse(path));
    }

    public static boolean match(@Nonnull String path, String value) {
        return value != null && PathExpression.parse(path).match(value) != null;
    }

    public String getPath() {
        return this.path;
    }

    public PathSegment[] getSegments() {
        return this.segments;
    }

    public boolean isDirect() {
        return this.segments.length == 1 && this.segments[0].getType() == PathSegment.Type.LITERAL;
    }

    public Map<String, String> match(@Nonnull String path) {
        if (this.isDirect()) {
            return this.path.equals(path) ? Collections.emptyMap() : null;
        }
        LinkedHashMap<String, String> variableMap = new LinkedHashMap<String, String>();
        int end = 0;
        int len = this.segments.length;
        for (int i = 0; i < len; ++i) {
            int start;
            PathSegment segment = this.segments[i];
            if (end != -1 && segment.match(new KeyString(path), start = end + 1, end = path.indexOf(47, start), variableMap)) {
                if (i != len - 1 || !segment.isTailMatching()) continue;
                return variableMap;
            }
            return null;
        }
        return end == -1 ? variableMap : null;
    }

    public int compareTo(PathExpression other, String lookupPath) {
        boolean equalsPath = this.path.equals(lookupPath);
        boolean otherEqualsPath = other.path.equals(lookupPath);
        if (equalsPath) {
            return otherEqualsPath ? 0 : -1;
        }
        if (otherEqualsPath) {
            return 1;
        }
        return this.compareTo(other);
    }

    @Override
    public int compareTo(PathExpression other) {
        int size = this.segments.length;
        int otherSize = other.segments.length;
        if (this.isDirect() && other.isDirect()) {
            return other.path.length() - this.path.length();
        }
        for (int i = 0; i < size && i < otherSize; ++i) {
            int result = this.segments[i].compareTo(other.segments[i]);
            if (result == 0) continue;
            return result;
        }
        return size - otherSize;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != PathExpression.class) {
            return false;
        }
        return this.path.equals(((PathExpression)obj).path);
    }

    public String toString() {
        if (this.isDirect()) {
            return this.path;
        }
        StringBuilder sb = new StringBuilder(this.path.length());
        int varIndex = 1;
        block6: for (PathSegment segment : this.segments) {
            sb.append('/');
            switch (segment.getType()) {
                case LITERAL: {
                    sb.append(segment.getValue());
                    continue block6;
                }
                case WILDCARD_TAIL: {
                    List<String> variables = segment.getVariables();
                    if (variables == null) {
                        sb.append("{path}");
                        continue block6;
                    }
                    sb.append('{').append(variables.get(0)).append('}');
                    continue block6;
                }
                case VARIABLE: {
                    sb.append('{');
                    String value = segment.getValue();
                    if (value.isEmpty()) {
                        sb.append("var").append(varIndex++);
                    } else {
                        sb.append(value);
                    }
                    sb.append('}');
                    continue block6;
                }
                case PATTERN: 
                case PATTERN_MULTI: {
                    sb.append('{').append("var").append(varIndex++).append('}');
                    continue block6;
                }
            }
        }
        return sb.toString();
    }
}

