/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition;

import java.util.Objects;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.condition.Condition;

public final class ConditionWrapper
implements Condition<ConditionWrapper, HttpRequest> {
    private final Condition<Object, HttpRequest> condition;

    private ConditionWrapper(Condition<?, HttpRequest> condition) {
        this.condition = Objects.requireNonNull(condition);
    }

    public static ConditionWrapper wrap(Condition<?, HttpRequest> condition) {
        return condition instanceof ConditionWrapper ? (ConditionWrapper)condition : new ConditionWrapper(condition);
    }

    @Override
    public ConditionWrapper combine(ConditionWrapper other) {
        return new ConditionWrapper(this.condition.combine(other.condition));
    }

    @Override
    public ConditionWrapper match(HttpRequest request) {
        Condition match = (Condition)this.condition.match(request);
        return match == null ? null : new ConditionWrapper(match);
    }

    @Override
    public int compareTo(ConditionWrapper other, HttpRequest request) {
        if (other == null) {
            return -1;
        }
        return this.condition.compareTo(other.condition, request);
    }

    public Condition<Object, HttpRequest> getCondition() {
        return this.condition;
    }

    public int hashCode() {
        return this.condition.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ConditionWrapper.class) {
            return false;
        }
        return this.condition.equals(((ConditionWrapper)obj).condition);
    }

    public String toString() {
        return this.condition.toString();
    }
}

