/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.argument;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.argument.ArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;

@Activate
public class MiscArgumentResolver
implements ArgumentResolver {
    private static final Set<Class<?>> SUPPORTED_TYPES = new HashSet();

    @Override
    public boolean accept(ParameterMeta parameter) {
        return SUPPORTED_TYPES.contains(parameter.getActualType());
    }

    @Override
    public Object resolve(ParameterMeta parameter, HttpRequest request, HttpResponse response) {
        Class<?> type = parameter.getActualType();
        if (type == HttpRequest.class) {
            return request;
        }
        if (type == HttpResponse.class) {
            return response;
        }
        if (type == HttpMethods.class) {
            return HttpMethods.of((String)request.method());
        }
        if (type == Locale.class) {
            return request.locale();
        }
        if (type == InputStream.class) {
            return request.inputStream();
        }
        if (type == OutputStream.class) {
            return response.outputStream();
        }
        return null;
    }

    static {
        SUPPORTED_TYPES.add(HttpRequest.class);
        SUPPORTED_TYPES.add(HttpResponse.class);
        SUPPORTED_TYPES.add(HttpMethods.class);
        SUPPORTED_TYPES.add(Locale.class);
        SUPPORTED_TYPES.add(InputStream.class);
        SUPPORTED_TYPES.add(OutputStream.class);
    }
}

