/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.h3;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.incubator.codec.http3.DefaultHttp3DataFrame;
import io.netty.incubator.codec.http3.DefaultHttp3Headers;
import io.netty.incubator.codec.http3.DefaultHttp3HeadersFrame;
import io.netty.incubator.codec.http3.Http3;
import io.netty.incubator.codec.http3.Http3DataFrame;
import io.netty.incubator.codec.http3.Http3ErrorCode;
import io.netty.incubator.codec.http3.Http3Exception;
import io.netty.incubator.codec.http3.Http3GoAwayFrame;
import io.netty.incubator.codec.http3.Http3Headers;
import io.netty.incubator.codec.http3.Http3HeadersFrame;
import io.netty.incubator.codec.http3.Http3RequestStreamInitializer;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import org.apache.dubbo.common.logger.FluentLogger;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.remoting.http3.netty4.Constants;
import org.apache.dubbo.remoting.http3.netty4.Http2HeadersAdapter;
import org.apache.dubbo.remoting.http3.netty4.Http3HeadersAdapter;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

@ChannelHandler.Sharable
public class Http3ClientFrameCodec
extends ChannelDuplexHandler {
    private static final FluentLogger LOGGER = FluentLogger.of(Http3ClientFrameCodec.class);
    public static final Http3ClientFrameCodec INSTANCE = new Http3ClientFrameCodec();

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http3HeadersFrame) {
            Http3Headers headers = ((Http3HeadersFrame)msg).headers();
            if (headers.contains((Object)Constants.TRI_PING)) {
                this.pingAck(ctx);
            } else {
                boolean endStream = headers.contains((Object)TripleHeaderEnum.STATUS_KEY.getKey());
                ctx.fireChannelRead((Object)new DefaultHttp2HeadersFrame((Http2Headers)new Http2HeadersAdapter(headers), endStream));
            }
        } else if (msg instanceof Http3DataFrame) {
            ctx.fireChannelRead((Object)new DefaultHttp2DataFrame(((Http3DataFrame)msg).content()));
        } else if (msg instanceof Http3GoAwayFrame) {
            ctx.fireUserEventTriggered((Object)new DefaultHttp2GoAwayFrame(((Http3GoAwayFrame)msg).id()));
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void pingAck(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.channel().parent().pipeline();
        pipeline.fireChannelRead((Object)new DefaultHttp2PingFrame(0L, true));
        pipeline.fireChannelReadComplete();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (ctx instanceof QuicStreamChannel) {
            ctx.fireChannelRead((Object)new DefaultHttp2DataFrame(Unpooled.EMPTY_BUFFER, true));
        } else {
            ctx.fireChannelReadComplete();
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame frame = (Http2HeadersFrame)msg;
            ctx.write((Object)new DefaultHttp3HeadersFrame((Http3Headers)new Http3HeadersAdapter(frame.headers())), promise);
            if (frame.isEndStream()) {
                ((QuicStreamChannel)ctx.channel()).shutdownOutput(promise);
            }
        } else if (msg instanceof Http2DataFrame) {
            Http2DataFrame frame = (Http2DataFrame)msg;
            if (frame.isEndStream()) {
                ((QuicStreamChannel)ctx.channel()).shutdownOutput(promise);
                return;
            }
            ctx.write((Object)new DefaultHttp3DataFrame(frame.content()), promise);
        } else if (msg instanceof Http2PingFrame) {
            this.sendPing((QuicChannel)ctx.channel());
        } else {
            ctx.write(msg, promise);
        }
    }

    private void sendPing(QuicChannel channel) {
        Http3.newRequestStream((QuicChannel)channel, (ChannelHandler)new Http3RequestStreamInitializer(){

            protected void initRequestStream(QuicStreamChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{INSTANCE});
            }
        }).addListener(future -> {
            if (future.isSuccess()) {
                QuicStreamChannel streamChannel = (QuicStreamChannel)future.getNow();
                DefaultHttp3Headers header = new DefaultHttp3Headers(false);
                header.set((Object)Http2Headers.PseudoHeaderName.METHOD.value(), (Object)HttpMethods.OPTIONS.name());
                header.set((Object)Http2Headers.PseudoHeaderName.PATH.value(), (Object)"*");
                header.set((Object)Http2Headers.PseudoHeaderName.SCHEME.value(), (Object)"https");
                header.set((Object)Constants.TRI_PING, (Object)"0");
                streamChannel.write((Object)new DefaultHttp3HeadersFrame((Http3Headers)header));
                streamChannel.shutdownOutput();
            } else {
                LOGGER.warn("6-16", "Failed to send ping frame", future.cause());
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Http3Exception e;
        Http3ErrorCode errorCode;
        if (cause instanceof Http3Exception && (errorCode = (e = (Http3Exception)cause).errorCode()) == Http3ErrorCode.H3_CLOSED_CRITICAL_STREAM) {
            ctx.fireUserEventTriggered((Object)new DefaultHttp2ResetFrame((long)(256 + errorCode.ordinal())));
            return;
        }
        super.exceptionCaught(ctx, cause);
    }
}

