/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionDirector;
import org.apache.dubbo.common.extension.ExtensionInjector;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.PojoUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.support.RpcUtils;

public final class MockInvoker<T>
implements Invoker<T> {
    private final ProxyFactory proxyFactory;
    private static final Map<String, Invoker<?>> MOCK_MAP = new ConcurrentHashMap();
    private static final Map<String, Throwable> THROWABLE_MAP = new ConcurrentHashMap<String, Throwable>();
    private final URL url;
    private final Class<T> type;

    public MockInvoker(URL url, Class<T> type) {
        this.url = url;
        this.type = type;
        this.proxyFactory = (ProxyFactory)url.getOrDefaultFrameworkModel().getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    }

    public static Object parseMockValue(String mock) throws Exception {
        return MockInvoker.parseMockValue(mock, null);
    }

    public static Object parseMockValue(String mock, Type[] returnTypes) throws Exception {
        Object value = "empty".equals(mock) ? ReflectUtils.getEmptyObject(returnTypes != null && returnTypes.length > 0 ? (Class)returnTypes[0] : null) : ("null".equals(mock) ? null : ("true".equals(mock) ? Boolean.valueOf(true) : ("false".equals(mock) ? Boolean.valueOf(false) : (mock.length() >= 2 && (mock.startsWith("\"") && mock.endsWith("\"") || mock.startsWith("'") && mock.endsWith("'")) ? mock.subSequence(1, mock.length() - 1) : (returnTypes != null && returnTypes.length > 0 && returnTypes[0] == String.class ? mock : (StringUtils.isNumeric((String)mock, (boolean)false) ? JsonUtils.toJavaObject((String)mock, Object.class) : (mock.startsWith("{") ? JsonUtils.toJavaObject((String)mock, Map.class) : (mock.startsWith("[") ? JsonUtils.toJavaList((String)mock, Object.class) : mock))))))));
        if (ArrayUtils.isNotEmpty((Object[])returnTypes)) {
            value = PojoUtils.realize((Object)value, (Class)((Class)returnTypes[0]), returnTypes.length > 1 ? returnTypes[1] : null);
        }
        return value;
    }

    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        String mock;
        if (invocation instanceof RpcInvocation) {
            ((RpcInvocation)invocation).setInvoker(this);
        }
        if (StringUtils.isBlank((CharSequence)(mock = this.getUrl().getMethodParameter(invocation.getMethodName(), "mock")))) {
            throw new RpcException(new IllegalAccessException("mock can not be null. url :" + this.url));
        }
        if ((mock = MockInvoker.normalizeMock(URL.decode((String)mock))).startsWith("return ")) {
            mock = mock.substring("return ".length()).trim();
            try {
                Type[] returnTypes = RpcUtils.getReturnTypes(invocation);
                Object value = MockInvoker.parseMockValue(mock, returnTypes);
                return AsyncRpcResult.newDefaultAsyncResult(value, invocation);
            }
            catch (Exception ew) {
                throw new RpcException("mock return invoke error. method :" + invocation.getMethodName() + ", mock:" + mock + ", url: " + this.url, (Throwable)ew);
            }
        }
        if (mock.startsWith("throw")) {
            if (StringUtils.isBlank((CharSequence)(mock = mock.substring("throw".length()).trim()))) {
                throw new RpcException("mocked exception for service degradation.");
            }
            Throwable t = MockInvoker.getThrowable(mock);
            throw new RpcException(3, t);
        }
        try {
            Invoker<T> invoker = this.getInvoker(mock);
            return invoker.invoke(invocation);
        }
        catch (Throwable t) {
            throw new RpcException("Failed to create mock implementation class " + mock, t);
        }
    }

    public static Throwable getThrowable(String throwstr) {
        Throwable throwable = THROWABLE_MAP.get(throwstr);
        if (throwable != null) {
            return throwable;
        }
        try {
            Class bizException = ReflectUtils.forName((String)throwstr);
            Constructor constructor = ReflectUtils.findConstructor((Class)bizException, String.class);
            Throwable t = (Throwable)constructor.newInstance("mocked exception for service degradation.");
            if (THROWABLE_MAP.size() < 1000) {
                THROWABLE_MAP.put(throwstr, t);
            }
            return t;
        }
        catch (Exception e) {
            throw new RpcException("mock throw error :" + throwstr + " argument error.", (Throwable)e);
        }
    }

    private Invoker<T> getInvoker(String mock) {
        Class serviceType = ReflectUtils.forName((String)this.url.getServiceInterface());
        String mockService = ConfigUtils.isDefault((String)mock) ? serviceType.getName() + "Mock" : mock;
        Invoker<Object> invoker = MOCK_MAP.get(mockService);
        if (invoker != null) {
            return invoker;
        }
        Object mockObject = MockInvoker.getMockObject(this.url.getOrDefaultApplicationModel().getExtensionDirector(), mock, serviceType);
        invoker = this.proxyFactory.getInvoker(mockObject, serviceType, this.url);
        if (MOCK_MAP.size() < 10000) {
            MOCK_MAP.put(mockService, invoker);
        }
        return invoker;
    }

    public static Object getMockObject(ExtensionDirector extensionDirector, String mockService, Class serviceType) {
        Class mockClass;
        boolean isDefault = ConfigUtils.isDefault((String)mockService);
        if (isDefault) {
            mockService = serviceType.getName() + "Mock";
        }
        try {
            mockClass = ReflectUtils.forName((String)mockService);
        }
        catch (Exception e) {
            ExtensionInjector extensionFactory;
            Object obj;
            if (!isDefault && (obj = (extensionFactory = (ExtensionInjector)extensionDirector.getExtensionLoader(ExtensionInjector.class).getAdaptiveExtension()).getInstance(serviceType, mockService)) != null) {
                return obj;
            }
            throw new IllegalStateException("Did not find mock class or instance " + mockService + ", please check if there's mock class or instance implementing interface " + serviceType.getName(), e);
        }
        if (mockClass == null || !serviceType.isAssignableFrom(mockClass)) {
            throw new IllegalStateException("The mock class " + mockClass.getName() + " not implement interface " + serviceType.getName());
        }
        try {
            return mockClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("No default constructor from mock class " + mockClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String normalizeMock(String mock) {
        if (mock == null) {
            return mock;
        }
        if ((mock = mock.trim()).length() == 0) {
            return mock;
        }
        if ("return".equalsIgnoreCase(mock)) {
            return "return null";
        }
        if (ConfigUtils.isDefault((String)mock) || "fail".equalsIgnoreCase(mock) || "force".equalsIgnoreCase(mock)) {
            return "default";
        }
        if (mock.startsWith("fail:")) {
            mock = mock.substring("fail:".length()).trim();
        }
        if (mock.startsWith("force:")) {
            mock = mock.substring("force:".length()).trim();
        }
        if (mock.startsWith("return ") || mock.startsWith("throw")) {
            mock = mock.replace('`', '\"');
        }
        return mock;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isAvailable() {
        return true;
    }

    public void destroy() {
    }

    @Override
    public Class<T> getInterface() {
        return this.type;
    }
}

