/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter.tps;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.filter.tps.StatItem;
import org.apache.dubbo.rpc.filter.tps.TPSLimiter;
import org.apache.dubbo.rpc.support.RpcUtils;

public class DefaultTPSLimiter
implements TPSLimiter {
    private final ConcurrentMap<String, StatItem> stats = new ConcurrentHashMap<String, StatItem>();

    @Override
    public boolean isAllowable(URL url, Invocation invocation) {
        boolean isMethodLevelTpsConfigured = url.hasMethodParameter(RpcUtils.getMethodName(invocation), "tps");
        String key = isMethodLevelTpsConfigured ? url.getServiceKey() + "#" + RpcUtils.getMethodName(invocation) : url.getServiceKey();
        int rate = url.getMethodParameter(RpcUtils.getMethodName(invocation), "tps", -1);
        long interval = url.getMethodParameter(RpcUtils.getMethodName(invocation), "tps.interval", 60000L);
        if (rate > 0) {
            StatItem statItem = (StatItem)this.stats.get(key);
            if (statItem == null) {
                this.stats.putIfAbsent(key, new StatItem(key, rate, interval));
                statItem = (StatItem)this.stats.get(key);
            } else if (statItem.getRate() != rate || statItem.getInterval() != interval) {
                this.stats.put(key, new StatItem(key, rate, interval));
                statItem = (StatItem)this.stats.get(key);
            }
            return statItem.isAllowable();
        }
        StatItem statItem = (StatItem)this.stats.get(key);
        if (statItem != null) {
            this.stats.remove(key);
        }
        return true;
    }
}

