/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi;

import java.lang.reflect.Method;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.io.Bytes;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPINamingStrategy;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.OpenAPI;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public class DefaultOpenAPINamingStrategy
implements OpenAPINamingStrategy {
    @Override
    public String generateOperationId(MethodMeta methodMeta, OpenAPI openAPI) {
        return methodMeta.getMethod().getName();
    }

    @Override
    public String resolveOperationIdConflict(int attempt, String operationId, MethodMeta methodMeta, OpenAPI openAPI) {
        String sig;
        Method method = methodMeta.getMethod();
        if (attempt == 1 && (sig = TypeUtils.buildSig((Method)method)) != null) {
            return method.getName() + '_' + sig;
        }
        return method.getName() + '_' + DefaultOpenAPINamingStrategy.buildPostfix(attempt, method.toString());
    }

    @Override
    public String generateSchemaName(Class<?> clazz, OpenAPI openAPI) {
        return clazz.getSimpleName();
    }

    @Override
    public String resolveSchemaNameConflict(int attempt, String schemaName, Class<?> clazz, OpenAPI openAPI) {
        return clazz.getSimpleName() + '_' + DefaultOpenAPINamingStrategy.buildPostfix(attempt, clazz.getName());
    }

    private static String buildPostfix(int attempt, String str) {
        if (attempt > 4) {
            str = str + ThreadLocalRandom.current().nextInt(10000);
        }
        return Bytes.bytes2hex((byte[])Bytes.getMD5((String)str), (int)0, (int)Math.min(4, attempt));
    }
}

