/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.filter;

import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestFilter;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.MultivaluedMapWrapper;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.filter.InterceptorContextImpl;

final class ReaderInterceptorContextImpl
extends InterceptorContextImpl
implements ReaderInterceptorContext {
    private final HttpResponse response;
    private final RestFilter.FilterChain chain;
    private MultivaluedMap<String, String> headers;

    public ReaderInterceptorContextImpl(HttpRequest request, HttpResponse response, RestFilter.FilterChain chain) {
        super(request);
        this.response = response;
        this.chain = chain;
        this.headers = new MultivaluedMapWrapper(request.headers());
    }

    public Object proceed() throws IOException, WebApplicationException {
        try {
            this.chain.doFilter(this.request, this.response);
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        return null;
    }

    public InputStream getInputStream() {
        return this.request.inputStream();
    }

    public void setInputStream(InputStream is) {
        this.request.setInputStream(is);
    }

    public MultivaluedMap<String, String> getHeaders() {
        Object headers = this.headers;
        if (headers == null) {
            this.headers = headers = new MultivaluedMapWrapper(this.request.headers());
        }
        return headers;
    }

    public MediaType getMediaType() {
        return Helper.toMediaType(this.request.mediaType());
    }

    public void setMediaType(MediaType mediaType) {
        this.request.setContentType(Helper.toString(mediaType));
    }
}

