/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.filter;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.JaxrsHttpRequestAdapter;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.JaxrsHttpResponseAdapter;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.MultivaluedMapWrapper;
import org.jboss.resteasy.specimpl.RequestImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyUriInfo;

final class ContainerRequestContextImpl
implements ContainerRequestContext {
    private final org.apache.dubbo.remoting.http12.HttpRequest request;
    private final org.apache.dubbo.remoting.http12.HttpResponse response;
    private Request req;
    private MultivaluedMap<String, String> headers;
    private UriInfo uriInfo;
    private boolean aborted;

    public ContainerRequestContextImpl(org.apache.dubbo.remoting.http12.HttpRequest request, org.apache.dubbo.remoting.http12.HttpResponse response) {
        this.request = request;
        this.response = response;
    }

    public Object getProperty(String name) {
        return this.request.attribute(name);
    }

    public Collection<String> getPropertyNames() {
        return this.request.parameterNames();
    }

    public void setProperty(String name, Object object) {
        this.request.setAttribute(name, object);
    }

    public void removeProperty(String name) {
        this.request.removeAttribute(name);
    }

    public UriInfo getUriInfo() {
        UriInfo uriInfo = this.uriInfo;
        if (uriInfo == null) {
            this.uriInfo = uriInfo = new ResteasyUriInfo(this.request.rawPath(), this.request.query(), "/");
        }
        return uriInfo;
    }

    public void setRequestUri(URI requestUri) {
        String query = requestUri.getRawQuery();
        this.request.setUri(requestUri.getRawPath() + (query == null ? "" : '?' + query));
    }

    public void setRequestUri(URI baseUri, URI requestUri) {
        String query = requestUri.getRawQuery();
        this.request.setUri(baseUri.getRawPath() + requestUri.getRawPath() + (query == null ? "" : '?' + query));
    }

    public Request getRequest() {
        Request req = this.req;
        if (req == null) {
            this.req = req = new RequestImpl((HttpRequest)new JaxrsHttpRequestAdapter(this.request), (HttpResponse)new JaxrsHttpResponseAdapter(this.response));
        }
        return req;
    }

    public String getMethod() {
        return this.request.method();
    }

    public void setMethod(String method) {
        this.request.setMethod(method);
    }

    public MultivaluedMap<String, String> getHeaders() {
        Object headers = this.headers;
        if (headers == null) {
            this.headers = headers = new MultivaluedMapWrapper(this.request.headers());
        }
        return headers;
    }

    public String getHeaderString(String name) {
        return this.request.header((CharSequence)name);
    }

    public Date getDate() {
        return null;
    }

    public Locale getLanguage() {
        return this.request.locale();
    }

    public int getLength() {
        return this.request.contentLength();
    }

    public MediaType getMediaType() {
        return Helper.toMediaType(this.request.mediaType());
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return Helper.toMediaTypes(this.request.accept());
    }

    public List<Locale> getAcceptableLanguages() {
        return this.request.locales();
    }

    public Map<String, Cookie> getCookies() {
        Collection cookies = this.request.cookies();
        HashMap<String, Cookie> result = new HashMap<String, Cookie>(cookies.size());
        for (HttpCookie cookie : cookies) {
            result.put(cookie.name(), (Cookie)Helper.convert(cookie));
        }
        return result;
    }

    public boolean hasEntity() {
        return this.request.inputStream() != null;
    }

    public InputStream getEntityStream() {
        return this.request.inputStream();
    }

    public void setEntityStream(InputStream input) {
        this.request.setInputStream(input);
    }

    public SecurityContext getSecurityContext() {
        return null;
    }

    public void setSecurityContext(SecurityContext context) {
    }

    public void abortWith(Response response) {
        this.response.setBody(Helper.toBody(response));
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }
}

