/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpRequest;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.rest.ParamType;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.NamedValueMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.AbstractJaxrsArgumentResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.Annotations;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;

@Activate(onClass={"javax.ws.rs.MatrixParam"})
public class MatrixParamArgumentResolver
extends AbstractJaxrsArgumentResolver {
    public Class<Annotation> accept() {
        return Annotations.MatrixParam.type();
    }

    protected ParamType getParamType(NamedValueMeta meta) {
        return ParamType.MatrixVariable;
    }

    protected Object resolveValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return CollectionUtils.first(MatrixParamArgumentResolver.doResolveCollectionValue(meta, request));
    }

    protected Object resolveCollectionValue(NamedValueMeta meta, HttpRequest request, HttpResponse response) {
        return MatrixParamArgumentResolver.doResolveCollectionValue(meta, request);
    }

    private static List<String> doResolveCollectionValue(NamedValueMeta meta, HttpRequest request) {
        Map variableMap = (Map)request.attribute("org.springframework.web.servlet.HandlerMapping.uriTemplateVariables");
        return RequestUtils.parseMatrixVariableValues((Map)variableMap, (String)meta.name());
    }
}

