/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs;

import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.dubbo.rpc.protocol.tri.rest.support.jaxrs.MultivaluedMapWrapper;
import org.apache.dubbo.rpc.protocol.tri.rest.util.RequestUtils;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyUriInfo;

public final class JaxrsHttpRequestAdapter
implements HttpRequest {
    private final org.apache.dubbo.remoting.http12.HttpRequest request;
    private HttpHeaders headers;
    private ResteasyUriInfo uriInfo;

    public JaxrsHttpRequestAdapter(org.apache.dubbo.remoting.http12.HttpRequest request) {
        this.request = request;
    }

    public HttpHeaders getHttpHeaders() {
        HttpHeaders headers = this.headers;
        if (headers == null) {
            this.headers = headers = new ResteasyHttpHeaders(new MultivaluedMapWrapper(this.request.headers()));
        }
        return headers;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.headers.getRequestHeaders();
    }

    public InputStream getInputStream() {
        return this.request.inputStream();
    }

    public void setInputStream(InputStream stream) {
        this.request.setInputStream(stream);
    }

    public ResteasyUriInfo getUri() {
        ResteasyUriInfo uriInfo = this.uriInfo;
        if (uriInfo == null) {
            this.uriInfo = uriInfo = new ResteasyUriInfo(this.request.rawPath(), this.request.query(), "/");
        }
        return uriInfo;
    }

    public String getHttpMethod() {
        return this.request.method();
    }

    public void setHttpMethod(String method) {
        this.request.setMethod(method);
    }

    public void setRequestUri(URI requestUri) throws IllegalStateException {
        String query = requestUri.getRawQuery();
        this.request.setUri(requestUri.getRawPath() + (query == null ? "" : '?' + query));
    }

    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        String query = requestUri.getRawQuery();
        this.request.setUri(baseUri.getRawPath() + requestUri.getRawPath() + (query == null ? "" : '?' + query));
    }

    public MultivaluedMap<String, String> getFormParameters() {
        MultivaluedHashMap result = new MultivaluedHashMap();
        for (String name : this.request.formParameterNames()) {
            List values = this.request.formParameterValues(name);
            if (values == null) continue;
            for (String value : values) {
                result.add((Object)name, (Object)RequestUtils.encodeURL((String)value));
            }
        }
        return result;
    }

    public MultivaluedMap<String, String> getDecodedFormParameters() {
        return new MultivaluedMapWrapper(RequestUtils.getFormParametersMap((org.apache.dubbo.remoting.http12.HttpRequest)this.request));
    }

    public Object getAttribute(String attribute) {
        return this.request.attribute(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.request.attributeNames());
    }

    public ResteasyAsynchronousContext getAsyncContext() {
        throw new UnsupportedOperationException();
    }

    public boolean isInitial() {
        return false;
    }

    public void forward(String path) {
        throw new UnsupportedOperationException();
    }

    public boolean wasForwarded() {
        return false;
    }
}

