/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.websocket.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WebSocketServerUpgradeCodec
implements HttpServerUpgradeHandler.UpgradeCodec {
    private final List<Class<? extends ChannelHandler>> shouldRemoveChannelHandlers;
    private final ChannelHandler[] channelHandlers;

    public WebSocketServerUpgradeCodec(List<Class<? extends ChannelHandler>> shouldRemoveChannelHandlers, ChannelHandler ... channelHandlers) {
        this.shouldRemoveChannelHandlers = shouldRemoveChannelHandlers;
        this.channelHandlers = channelHandlers;
    }

    public Collection<CharSequence> requiredUpgradeHeaders() {
        return Collections.emptyList();
    }

    public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders upgradeHeaders) {
        if (this.shouldRemoveChannelHandlers != null) {
            for (Class clazz : this.shouldRemoveChannelHandlers) {
                ctx.pipeline().remove(clazz);
            }
        }
        if (this.channelHandlers != null) {
            for (ChannelHandler channelHandler : this.channelHandlers) {
                ctx.pipeline().addLast(new ChannelHandler[]{channelHandler});
            }
        }
        return false;
    }

    public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
    }
}

