/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.multiple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.registry.support.AbstractRegistry;

public class MultipleRegistry
extends AbstractRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleRegistry.class);
    public static final String REGISTRY_FOR_SERVICE = "service-registry";
    public static final String REGISTRY_FOR_REFERENCE = "reference-registry";
    protected RegistryFactory registryFactory = (RegistryFactory)ExtensionLoader.getExtensionLoader(RegistryFactory.class).getAdaptiveExtension();
    private final Map<String, Registry> serviceRegistries = new ConcurrentHashMap<String, Registry>(4);
    private final Map<String, Registry> referenceRegistries = new ConcurrentHashMap<String, Registry>(4);
    private final Map<NotifyListener, MultipleNotifyListenerWrapper> multipleNotifyListenerMap = new ConcurrentHashMap<NotifyListener, MultipleNotifyListenerWrapper>(32);
    protected List<String> origServiceRegistryURLs;
    protected List<String> origReferenceRegistryURLs;
    protected List<String> effectServiceRegistryURLs;
    protected List<String> effectReferenceRegistryURLs;
    private URL registryUrl;
    private String applicationName;

    public MultipleRegistry(URL url) {
        this(url, true, true);
        boolean defaultRegistry = url.getParameter("default", true);
        if (defaultRegistry && this.effectServiceRegistryURLs.isEmpty() && this.effectReferenceRegistryURLs.isEmpty()) {
            throw new IllegalArgumentException("Illegal registry url. You need to configure parameter service-registry or reference-registry");
        }
    }

    public MultipleRegistry(URL url, boolean initServiceRegistry, boolean initReferenceRegistry) {
        super(url);
        this.registryUrl = url;
        this.applicationName = url.getParameter("application");
        this.init();
        this.checkApplicationName(this.applicationName);
        HashMap<String, Registry> registryMap = new HashMap<String, Registry>();
        if (initServiceRegistry) {
            this.initServiceRegistry(url, registryMap);
        }
        if (initReferenceRegistry) {
            this.initReferenceRegistry(url, registryMap);
        }
    }

    protected void initServiceRegistry(URL url, Map<String, Registry> registryMap) {
        this.origServiceRegistryURLs = url.getParameter(REGISTRY_FOR_SERVICE, new ArrayList());
        this.effectServiceRegistryURLs = this.filterServiceRegistry(this.origServiceRegistryURLs);
        for (String tmpUrl : this.effectServiceRegistryURLs) {
            if (registryMap.get(tmpUrl) != null) {
                this.serviceRegistries.put(tmpUrl, registryMap.get(tmpUrl));
                continue;
            }
            Registry registry = this.getRegistry(URL.valueOf((String)tmpUrl));
            registryMap.put(tmpUrl, registry);
            this.serviceRegistries.put(tmpUrl, registry);
        }
    }

    protected void initReferenceRegistry(URL url, Map<String, Registry> registryMap) {
        this.origReferenceRegistryURLs = url.getParameter(REGISTRY_FOR_REFERENCE, new ArrayList());
        this.effectReferenceRegistryURLs = this.filterReferenceRegistry(this.origReferenceRegistryURLs);
        for (String tmpUrl : this.effectReferenceRegistryURLs) {
            if (registryMap.get(tmpUrl) != null) {
                this.referenceRegistries.put(tmpUrl, registryMap.get(tmpUrl));
                continue;
            }
            Registry registry = this.getRegistry(URL.valueOf((String)tmpUrl));
            registryMap.put(tmpUrl, registry);
            this.referenceRegistries.put(tmpUrl, registry);
        }
    }

    protected Registry getRegistry(URL url) {
        try {
            return this.registryFactory.getRegistry(url);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            throw t;
        }
    }

    public URL getUrl() {
        return this.registryUrl;
    }

    public boolean isAvailable() {
        boolean available = this.serviceRegistries.isEmpty();
        for (Registry serviceRegistry : this.serviceRegistries.values()) {
            if (!serviceRegistry.isAvailable()) continue;
            available = true;
        }
        if (!available) {
            return false;
        }
        available = this.referenceRegistries.isEmpty();
        for (Registry referenceRegistry : this.referenceRegistries.values()) {
            if (!referenceRegistry.isAvailable()) continue;
            available = true;
        }
        return available;
    }

    public void destroy() {
        HashSet<Registry> registries = new HashSet<Registry>(this.serviceRegistries.values());
        registries.addAll(this.referenceRegistries.values());
        for (Registry registry : registries) {
            registry.destroy();
        }
    }

    public void register(URL url) {
        super.register(url);
        for (Registry registry : this.serviceRegistries.values()) {
            registry.register(url);
        }
    }

    public void unregister(URL url) {
        super.unregister(url);
        for (Registry registry : this.serviceRegistries.values()) {
            registry.unregister(url);
        }
    }

    public void subscribe(URL url, NotifyListener listener) {
        MultipleNotifyListenerWrapper multipleNotifyListenerWrapper = new MultipleNotifyListenerWrapper(listener);
        this.multipleNotifyListenerMap.put(listener, multipleNotifyListenerWrapper);
        for (Registry registry : this.referenceRegistries.values()) {
            SingleNotifyListener singleNotifyListener = new SingleNotifyListener(multipleNotifyListenerWrapper, registry);
            multipleNotifyListenerWrapper.putRegistryMap(registry.getUrl(), singleNotifyListener);
            registry.subscribe(url, (NotifyListener)singleNotifyListener);
        }
        super.subscribe(url, (NotifyListener)multipleNotifyListenerWrapper);
    }

    public void unsubscribe(URL url, NotifyListener listener) {
        MultipleNotifyListenerWrapper notifyListener = this.multipleNotifyListenerMap.remove(listener);
        for (Registry registry : this.referenceRegistries.values()) {
            SingleNotifyListener singleNotifyListener = notifyListener.registryMap.get(registry.getUrl());
            registry.unsubscribe(url, (NotifyListener)singleNotifyListener);
        }
        if (notifyListener != null) {
            super.unsubscribe(url, (NotifyListener)notifyListener);
            notifyListener.destroy();
        }
    }

    public List<URL> lookup(URL url) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Registry registry : this.referenceRegistries.values()) {
            List tmpUrls = registry.lookup(url);
            if (CollectionUtils.isEmpty((Collection)tmpUrls)) continue;
            urls.addAll(tmpUrls);
        }
        return urls;
    }

    protected void init() {
    }

    protected List<String> filterServiceRegistry(List<String> serviceRegistryURLs) {
        return serviceRegistryURLs;
    }

    protected List<String> filterReferenceRegistry(List<String> referenceRegistryURLs) {
        return referenceRegistryURLs;
    }

    protected void checkApplicationName(String applicationName) {
    }

    protected String getApplicationName() {
        return this.applicationName;
    }

    public Map<String, Registry> getServiceRegistries() {
        return this.serviceRegistries;
    }

    public Map<String, Registry> getReferenceRegistries() {
        return this.referenceRegistries;
    }

    public List<String> getOrigServiceRegistryURLs() {
        return this.origServiceRegistryURLs;
    }

    public List<String> getOrigReferenceRegistryURLs() {
        return this.origReferenceRegistryURLs;
    }

    public List<String> getEffectServiceRegistryURLs() {
        return this.effectServiceRegistryURLs;
    }

    public List<String> getEffectReferenceRegistryURLs() {
        return this.effectReferenceRegistryURLs;
    }

    protected static class SingleNotifyListener
    implements NotifyListener {
        MultipleNotifyListenerWrapper multipleNotifyListenerWrapper;
        Registry registry;
        volatile List<URL> urlList;

        public SingleNotifyListener(MultipleNotifyListenerWrapper multipleNotifyListenerWrapper, Registry registry) {
            this.registry = registry;
            this.multipleNotifyListenerWrapper = multipleNotifyListenerWrapper;
        }

        public synchronized void notify(List<URL> urls) {
            this.urlList = urls;
            if (this.multipleNotifyListenerWrapper != null) {
                this.multipleNotifyListenerWrapper.notifySourceListener();
            }
        }

        public void destroy() {
            this.multipleNotifyListenerWrapper = null;
            this.registry = null;
        }

        public List<URL> getUrlList() {
            return this.urlList;
        }
    }

    protected static class MultipleNotifyListenerWrapper
    implements NotifyListener {
        Map<URL, SingleNotifyListener> registryMap = new ConcurrentHashMap<URL, SingleNotifyListener>(4);
        NotifyListener sourceNotifyListener;

        public MultipleNotifyListenerWrapper(NotifyListener sourceNotifyListener) {
            this.sourceNotifyListener = sourceNotifyListener;
        }

        public void putRegistryMap(URL registryURL, SingleNotifyListener singleNotifyListener) {
            this.registryMap.put(registryURL, singleNotifyListener);
        }

        public void destroy() {
            for (SingleNotifyListener singleNotifyListener : this.registryMap.values()) {
                if (singleNotifyListener == null) continue;
                singleNotifyListener.destroy();
            }
            this.registryMap.clear();
            this.sourceNotifyListener = null;
        }

        public synchronized void notifySourceListener() {
            ArrayList<URL> notifyURLs = new ArrayList<URL>();
            URL emptyURL = null;
            for (SingleNotifyListener singleNotifyListener : this.registryMap.values()) {
                List<URL> tmpUrls = singleNotifyListener.getUrlList();
                if (CollectionUtils.isEmpty(tmpUrls)) continue;
                if (tmpUrls.size() == 1 && tmpUrls.get(0) != null && "empty".equals(tmpUrls.get(0).getProtocol())) {
                    if (emptyURL != null) continue;
                    emptyURL = tmpUrls.get(0);
                    continue;
                }
                notifyURLs.addAll(tmpUrls);
            }
            if (emptyURL != null && notifyURLs.isEmpty()) {
                notifyURLs.add(emptyURL);
            }
            this.notify(notifyURLs);
        }

        public void notify(List<URL> urls) {
            this.sourceNotifyListener.notify(urls);
        }

        public Map<URL, SingleNotifyListener> getRegistryMap() {
            return this.registryMap;
        }
    }
}

