/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.CacheRefreshedEvent;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaEvent;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.event.Event;
import org.apache.dubbo.event.EventDispatcher;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscoveryRegistry;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.eureka.ConfigurableEurekaInstanceConfig;

public class EurekaServiceDiscovery
extends AbstractServiceDiscovery {
    private final EventDispatcher eventDispatcher = EventDispatcher.getDefaultExtension();
    private ApplicationInfoManager applicationInfoManager;
    private EurekaClient eurekaClient;
    private Set<String> subscribedServices;
    private String lastAppsHashCode;

    public void initialize(URL registryURL) throws Exception {
        Properties eurekaConfigProperties = this.buildEurekaConfigProperties(registryURL);
        this.initConfigurationManager(eurekaConfigProperties);
        this.initSubscribedServices(registryURL);
    }

    private Properties buildEurekaConfigProperties(URL registryURL) {
        Properties properties = new Properties();
        Map parameters = registryURL.getParameters();
        this.setDefaultProperties(registryURL, properties);
        parameters.entrySet().stream().filter(this::filterEurekaProperty).forEach(propertyEntry -> properties.setProperty((String)propertyEntry.getKey(), (String)propertyEntry.getValue()));
        return properties;
    }

    private void initSubscribedServices(URL registryURL) {
        this.subscribedServices = ServiceDiscoveryRegistry.parseServices((String)registryURL.getParameter("subscribed-services"));
    }

    private boolean filterEurekaProperty(Map.Entry<String, String> propertyEntry) {
        String propertyName = propertyEntry.getKey();
        return propertyName.startsWith("eureka.");
    }

    private void setDefaultProperties(URL registryURL, Properties properties) {
        this.setDefaultServiceURL(registryURL, properties);
        this.setDefaultInitialInstanceInfoReplicationIntervalSeconds(properties);
    }

    private void setDefaultServiceURL(URL registryURL, Properties properties) {
        StringBuilder defaultServiceURLBuilder = new StringBuilder("http://").append(registryURL.getHost()).append(":").append(registryURL.getPort()).append("/eureka");
        properties.setProperty("eureka.serviceUrl.default", defaultServiceURLBuilder.toString());
    }

    private void setDefaultInitialInstanceInfoReplicationIntervalSeconds(Properties properties) {
        properties.setProperty("eureka.appinfo.initial.replicate.time", "0");
    }

    private void initConfigurationManager(Properties eurekaConfigProperties) {
        ConfigurationManager.loadProperties((Properties)eurekaConfigProperties);
    }

    private void initApplicationInfoManager(ServiceInstance serviceInstance) {
        EurekaInstanceConfig eurekaInstanceConfig = this.buildEurekaInstanceConfig(serviceInstance);
        this.applicationInfoManager = new ApplicationInfoManager(eurekaInstanceConfig, (ApplicationInfoManager.OptionalArgs)null);
    }

    private void initEurekaClient(ServiceInstance serviceInstance) {
        if (this.eurekaClient != null) {
            return;
        }
        this.initApplicationInfoManager(serviceInstance);
        EurekaClient eurekaClient = this.createEurekaClient();
        this.registerEurekaEventListener(eurekaClient);
        this.eurekaClient = eurekaClient;
    }

    private void registerEurekaEventListener(EurekaClient eurekaClient) {
        eurekaClient.registerEventListener(this::onEurekaEvent);
    }

    private void onEurekaEvent(EurekaEvent event) {
        if (event instanceof CacheRefreshedEvent) {
            this.onCacheRefreshedEvent((CacheRefreshedEvent)CacheRefreshedEvent.class.cast(event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCacheRefreshedEvent(CacheRefreshedEvent event) {
        EurekaServiceDiscovery eurekaServiceDiscovery = this;
        synchronized (eurekaServiceDiscovery) {
            Applications applications = this.eurekaClient.getApplications();
            String appsHashCode = applications.getAppsHashCode();
            if (!Objects.equals(this.lastAppsHashCode, appsHashCode)) {
                this.dispatchServiceInstancesChangedEvent();
                this.lastAppsHashCode = appsHashCode;
            }
        }
    }

    private void dispatchServiceInstancesChangedEvent() {
        this.subscribedServices.forEach(serviceName -> this.eventDispatcher.dispatch((Event)new ServiceInstancesChangedEvent(serviceName, this.getInstances((String)serviceName))));
    }

    private EurekaClient createEurekaClient() {
        DefaultEurekaClientConfig eurekaClientConfig = new DefaultEurekaClientConfig();
        DiscoveryClient eurekaClient = new DiscoveryClient(this.applicationInfoManager, (EurekaClientConfig)eurekaClientConfig);
        return eurekaClient;
    }

    public void destroy() throws Exception {
        if (this.eurekaClient != null) {
            this.eurekaClient.shutdown();
        }
    }

    public void doRegister(ServiceInstance serviceInstance) {
        this.initEurekaClient(serviceInstance);
        this.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
    }

    private void setInstanceStatus(InstanceInfo.InstanceStatus status) {
        if (this.applicationInfoManager != null) {
            this.applicationInfoManager.setInstanceStatus(status);
        }
    }

    public void doUpdate(ServiceInstance serviceInstance) {
        this.setInstanceStatus(serviceInstance.isHealthy() ? InstanceInfo.InstanceStatus.UP : InstanceInfo.InstanceStatus.UNKNOWN);
    }

    public void unregister(ServiceInstance serviceInstance) throws RuntimeException {
        this.setInstanceStatus(InstanceInfo.InstanceStatus.OUT_OF_SERVICE);
    }

    public Set<String> getServices() {
        Applications applications = this.eurekaClient.getApplications();
        if (applications == null) {
            return Collections.emptySet();
        }
        List registered = applications.getRegisteredApplications();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (Application app : registered) {
            if (app.getInstances().isEmpty()) continue;
            names.add(app.getName().toLowerCase());
        }
        return names;
    }

    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        Application application = this.eurekaClient.getApplication(serviceName);
        if (application == null) {
            return Collections.emptyList();
        }
        List infos = application.getInstances();
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        for (InstanceInfo info : infos) {
            instances.add(this.buildServiceInstance(info));
        }
        return instances;
    }

    private ServiceInstance buildServiceInstance(InstanceInfo instance) {
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance(instance.getId(), instance.getAppName(), instance.getHostName(), Integer.valueOf(instance.isPortEnabled(InstanceInfo.PortType.SECURE) ? instance.getSecurePort() : instance.getPort()));
        serviceInstance.setMetadata(instance.getMetadata());
        return serviceInstance;
    }

    private EurekaInstanceConfig buildEurekaInstanceConfig(ServiceInstance serviceInstance) {
        ConfigurableEurekaInstanceConfig eurekaInstanceConfig = new ConfigurableEurekaInstanceConfig().setInstanceId(serviceInstance.getId()).setAppname(serviceInstance.getServiceName()).setIpAddress(serviceInstance.getHost()).setNonSecurePort(serviceInstance.getPort()).setMetadataMap(serviceInstance.getMetadata());
        return eurekaInstanceConfig;
    }
}

