/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.reactive.handler;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.reactive.calls.ReactorServerCalls;
import org.apache.dubbo.rpc.protocol.tri.observer.CallStreamObserver;
import org.apache.dubbo.rpc.stub.StubMethodHandler;
import reactor.core.publisher.Flux;

public class ManyToManyMethodHandler<T, R>
implements StubMethodHandler<T, R> {
    private final Function<Flux<T>, Flux<R>> func;

    public ManyToManyMethodHandler(Function<Flux<T>, Flux<R>> func) {
        this.func = func;
    }

    public CompletableFuture<StreamObserver<T>> invoke(Object[] arguments) {
        CallStreamObserver responseObserver = (CallStreamObserver)arguments[0];
        StreamObserver<T> requestObserver = ReactorServerCalls.manyToMany(responseObserver, this.func);
        return CompletableFuture.completedFuture(requestObserver);
    }
}

