/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.aot.generate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.aot.generate.JarScanner;
import org.apache.dubbo.common.extension.Adaptive;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class ClassSourceScanner
extends JarScanner {
    public static final ClassSourceScanner INSTANCE = new ClassSourceScanner();

    public List<Class<?>> spiClassesWithAdaptive() {
        Map<String, Class<?>> allClasses = this.getClasses();
        List<Class<?>> spiClasses = new ArrayList(allClasses.values()).stream().filter(it -> {
            if (null == it) {
                return false;
            }
            SPI anno = it.getAnnotation(SPI.class);
            if (null == anno) {
                return false;
            }
            Optional<Method> optional = Arrays.stream(it.getMethods()).filter(it2 -> it2.getAnnotation(Adaptive.class) != null).findAny();
            return optional.isPresent();
        }).collect(Collectors.toList());
        return spiClasses;
    }

    public Map<String, Class<?>> adaptiveClasses() {
        List<String> res = this.spiClassesWithAdaptive().stream().map(c -> c.getName() + "$Adaptive").collect(Collectors.toList());
        return this.forNames(res);
    }

    public List<Class<?>> configClasses() {
        return this.getClasses().values().stream().filter(c -> AbstractConfig.class.isAssignableFrom((Class<?>)c) && !Modifier.isAbstract(c.getModifiers())).collect(Collectors.toList());
    }

    public Map<String, Class<?>> distinctSpiExtensionClasses(Set<String> spiResource) {
        HashMap extensionClasses = new HashMap();
        spiResource.forEach(fileName -> {
            try {
                Enumeration<URL> resources = ClassLoader.getSystemResources(fileName);
                if (resources != null) {
                    while (resources.hasMoreElements()) {
                        extensionClasses.putAll(this.loadResource(resources.nextElement()));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return extensionClasses;
    }

    public List<Class<?>> scopeModelInitializer() {
        ArrayList classes = new ArrayList();
        classes.addAll(FrameworkModel.defaultModel().getBeanFactory().getRegisteredClasses());
        classes.addAll(FrameworkModel.defaultModel().defaultApplication().getBeanFactory().getRegisteredClasses());
        classes.addAll(FrameworkModel.defaultModel().defaultApplication().getDefaultModule().getBeanFactory().getRegisteredClasses());
        return classes.stream().distinct().collect(Collectors.toList());
    }

    private Map<String, Class<?>> loadResource(URL resourceUrl) {
        HashMap extensionClasses = new HashMap();
        try {
            List<String> newContentList = this.getResourceContent(resourceUrl);
            for (String line : newContentList) {
                try {
                    int i = line.indexOf(61);
                    String clazz = i > 0 ? line.substring(i + 1).trim() : line;
                    if (!StringUtils.isNotEmpty((String)clazz)) continue;
                    extensionClasses.put(clazz, this.getClasses().get(clazz));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return extensionClasses;
    }

    private List<String> getResourceContent(URL resourceUrl) throws IOException {
        ArrayList<String> newContentList = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceUrl.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                int ci = line.indexOf(35);
                if (ci >= 0) {
                    line = line.substring(0, ci);
                }
                if ((line = line.trim()).length() <= 0) continue;
                newContentList.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return newContentList;
    }
}

