/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.aot.generate;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.aot.api.JdkProxyDescriber;
import org.apache.dubbo.aot.generate.BasicJsonWriter;
import org.apache.dubbo.aot.generate.ProxyConfigMetadataRepository;

public class ProxyConfigWriter {
    public static final ProxyConfigWriter INSTANCE = new ProxyConfigWriter();

    public void write(BasicJsonWriter writer, ProxyConfigMetadataRepository repository) {
        writer.writeArray(repository.getProxyDescribers().stream().map(this::toAttributes).collect(Collectors.toList()));
    }

    private Map<String, Object> toAttributes(JdkProxyDescriber describer) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, describer);
        attributes.put("interfaces", describer.getProxiedInterfaces());
        return attributes;
    }

    private void handleCondition(Map<String, Object> attributes, JdkProxyDescriber describer) {
        if (describer.getReachableType() != null) {
            LinkedHashMap<String, String> conditionAttributes = new LinkedHashMap<String, String>();
            conditionAttributes.put("typeReachable", describer.getReachableType());
            attributes.put("condition", conditionAttributes);
        }
    }
}

