/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.aot.generate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.apache.dubbo.aot.generate.BasicJsonWriter;
import org.apache.dubbo.aot.generate.ProxyConfigMetadataRepository;
import org.apache.dubbo.aot.generate.ProxyConfigWriter;
import org.apache.dubbo.aot.generate.ReflectConfigMetadataRepository;
import org.apache.dubbo.aot.generate.ReflectionConfigWriter;
import org.apache.dubbo.aot.generate.ResourceConfigMetadataRepository;
import org.apache.dubbo.aot.generate.ResourceConfigWriter;

public class NativeConfigurationWriter {
    private final Path basePath;
    private final String groupId;
    private final String artifactId;

    public NativeConfigurationWriter(Path basePath, String groupId, String artifactId) {
        this.basePath = basePath;
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    protected void writeTo(String fileName, Consumer<BasicJsonWriter> writer) {
        try {
            File file = this.createIfNecessary(fileName);
            try (FileWriter out = new FileWriter(file);){
                writer.accept(this.createJsonWriter(out));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to write native configuration for " + fileName, ex);
        }
    }

    private File createIfNecessary(String filename) throws IOException {
        Path outputDirectory = this.basePath.resolve("META-INF").resolve("native-image");
        if (this.groupId != null && this.artifactId != null) {
            outputDirectory = outputDirectory.resolve(this.groupId).resolve(this.artifactId).resolve("dubbo");
        }
        outputDirectory.toFile().mkdirs();
        File file = outputDirectory.resolve(filename).toFile();
        file.createNewFile();
        return file;
    }

    public void writeReflectionConfig(ReflectConfigMetadataRepository repository) {
        this.writeTo("reflect-config.json", writer -> ReflectionConfigWriter.INSTANCE.write((BasicJsonWriter)writer, repository));
    }

    public void writeResourceConfig(ResourceConfigMetadataRepository repository) {
        this.writeTo("resource-config.json", writer -> ResourceConfigWriter.INSTANCE.write((BasicJsonWriter)writer, repository));
    }

    public void writeProxyConfig(ProxyConfigMetadataRepository repository) {
        this.writeTo("proxy-config.json", writer -> ProxyConfigWriter.INSTANCE.write((BasicJsonWriter)writer, repository));
    }

    private BasicJsonWriter createJsonWriter(Writer out) {
        return new BasicJsonWriter(out);
    }
}

