/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mutiny;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.rpc.protocol.tri.observer.CallStreamObserver;

public abstract class AbstractTripleMutinySubscriber<T>
implements Flow.Subscriber<T> {
    private volatile boolean cancelled;
    protected volatile CallStreamObserver<T> downstream;
    private final AtomicBoolean subscribed = new AtomicBoolean();
    private final AtomicBoolean hasSubscribed = new AtomicBoolean();
    private volatile Flow.Subscription subscription;
    private volatile boolean done;

    public void subscribe(CallStreamObserver<T> downstream) {
        if (downstream == null) {
            throw new NullPointerException();
        }
        if (this.subscribed.compareAndSet(false, true)) {
            this.downstream = downstream;
            if (this.subscription != null) {
                this.subscription.request(1L);
            }
        }
    }

    @Override
    public void onSubscribe(Flow.Subscription sub) {
        if (this.subscription == null && this.hasSubscribed.compareAndSet(false, true)) {
            this.subscription = sub;
            return;
        }
        sub.cancel();
    }

    @Override
    public void onNext(T item) {
        if (!this.done && !this.cancelled) {
            this.downstream.onNext(item);
            this.subscription.request(1L);
        }
    }

    @Override
    public void onError(Throwable t) {
        if (!this.cancelled) {
            this.done = true;
            this.downstream.onError(t);
        }
    }

    @Override
    public void onComplete() {
        if (!this.cancelled) {
            this.done = true;
            this.downstream.onCompleted();
        }
    }

    public void cancel() {
        if (!this.cancelled && this.subscription != null) {
            this.cancelled = true;
            this.subscription.cancel();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

