/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.mutiny;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.dubbo.rpc.protocol.tri.CancelableStreamObserver;
import org.apache.dubbo.rpc.protocol.tri.observer.CallStreamObserver;

public abstract class AbstractTripleMutinyPublisher<T>
extends CancelableStreamObserver<T>
implements Flow.Publisher<T>,
Flow.Subscription {
    private boolean canRequest;
    private long requested;
    private final AtomicBoolean subscribed = new AtomicBoolean();
    private volatile Flow.Subscriber<? super T> downstream;
    protected volatile CallStreamObserver<?> subscription;
    private final AtomicBoolean hasSub = new AtomicBoolean();
    private volatile boolean cancelled;
    private volatile boolean done;
    private volatile Consumer<CallStreamObserver<?>> onSubscribe;
    private volatile Runnable shutdownHook;
    private final AtomicBoolean calledShutdown = new AtomicBoolean();

    public AbstractTripleMutinyPublisher() {
    }

    public AbstractTripleMutinyPublisher(Consumer<CallStreamObserver<?>> onSubscribe, Runnable shutdownHook) {
        this.onSubscribe = onSubscribe;
        this.shutdownHook = shutdownHook;
    }

    protected void onSubscribe(CallStreamObserver<?> subscription) {
        if (subscription != null && this.subscription == null && this.hasSub.compareAndSet(false, true)) {
            this.subscription = subscription;
            subscription.disableAutoFlowControl();
            if (this.onSubscribe != null) {
                this.onSubscribe.accept(subscription);
            }
            return;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " supports only a single subscription");
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (this.subscribed.compareAndSet(false, true)) {
            this.downstream = s;
            s.onSubscribe(this);
            if (this.cancelled) {
                this.downstream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(long n) {
        AbstractTripleMutinyPublisher abstractTripleMutinyPublisher = this;
        synchronized (abstractTripleMutinyPublisher) {
            if (this.subscribed.get() && this.canRequest) {
                this.subscription.request(n >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
            } else {
                this.requested += n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRequest() {
        AbstractTripleMutinyPublisher abstractTripleMutinyPublisher = this;
        synchronized (abstractTripleMutinyPublisher) {
            if (!this.canRequest) {
                this.canRequest = true;
                long n = this.requested;
                this.subscription.request(n >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
            }
        }
    }

    @Override
    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.doShutdown();
        }
    }

    public void onNext(T item) {
        if (this.done || this.cancelled) {
            return;
        }
        this.downstream.onNext(item);
    }

    public void onError(Throwable t) {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.downstream.onError(t);
        this.doShutdown();
    }

    public void onCompleted() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.downstream.onComplete();
        this.doShutdown();
    }

    private void doShutdown() {
        Runnable r = this.shutdownHook;
        if (r != null && this.calledShutdown.compareAndSet(false, true)) {
            this.shutdownHook = null;
            r.run();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

