/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.event;

import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.metrics.registry.collector.NettyMetricsCollector;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class NettyEvent
extends TimeCounterEvent {
    public NettyEvent(ApplicationModel applicationModel, TypeWrapper typeWrapper) {
        super(applicationModel, typeWrapper);
        ScopeBeanFactory beanFactory = this.getSource().getBeanFactory();
        if (!beanFactory.isDestroyed()) {
            NettyMetricsCollector collector = (NettyMetricsCollector)((Object)beanFactory.getBean(NettyMetricsCollector.class));
            super.setAvailable(collector != null && collector.isCollectEnabled());
        }
    }

    public static NettyEvent toNettyEvent(ApplicationModel applicationModel) {
        return new NettyEvent(applicationModel, new TypeWrapper(MetricsLevel.APP, null, null, null)){

            public void customAfterPost(Object postResult) {
                super.putAttachment("nettyMetricsMap", postResult);
            }
        };
    }
}

