/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.builder;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.apache.dubbo.metadata.annotation.processing.builder.DeclaredTypeDefinitionBuilder;
import org.apache.dubbo.metadata.annotation.processing.builder.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.annotation.processing.util.FieldUtils;
import org.apache.dubbo.metadata.annotation.processing.util.TypeUtils;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;

public class GeneralTypeDefinitionBuilder
implements DeclaredTypeDefinitionBuilder {
    @Override
    public boolean accept(ProcessingEnvironment processingEnv, DeclaredType type) {
        return TypeUtils.isClassType(type);
    }

    @Override
    public TypeDefinition build(ProcessingEnvironment processingEnv, DeclaredType type, Map<String, TypeDefinition> typeCache) {
        String typeName = type.toString();
        TypeElement typeElement = TypeUtils.getType(processingEnv, typeName);
        return this.buildProperties(processingEnv, typeElement, typeCache);
    }

    protected TypeDefinition buildProperties(ProcessingEnvironment processingEnv, TypeElement type, Map<String, TypeDefinition> typeCache) {
        TypeDefinition definition = new TypeDefinition(type.toString());
        FieldUtils.getNonStaticFields(type).forEach(field -> {
            String fieldName = field.getSimpleName().toString();
            TypeDefinition propertyType = TypeDefinitionBuilder.build(processingEnv, field, typeCache);
            if (propertyType != null) {
                typeCache.put(propertyType.getType(), propertyType);
                definition.getProperties().put(fieldName, propertyType.getType());
            }
        });
        return definition;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

