/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.apache.dubbo.common.function.Predicates;
import org.apache.dubbo.common.function.Streams;
import org.apache.dubbo.metadata.annotation.processing.util.MemberUtils;
import org.apache.dubbo.metadata.annotation.processing.util.TypeUtils;

public interface FieldUtils {
    public static List<VariableElement> getDeclaredFields(Element element, Predicate<VariableElement> ... fieldFilters) {
        return element == null ? Collections.emptyList() : FieldUtils.getDeclaredFields(element.asType(), fieldFilters);
    }

    public static List<VariableElement> getDeclaredFields(Element element) {
        return FieldUtils.getDeclaredFields(element, Predicates.EMPTY_ARRAY);
    }

    public static List<VariableElement> getDeclaredFields(TypeMirror type, Predicate<VariableElement> ... fieldFilters) {
        return (List)Streams.filterAll(ElementFilter.fieldsIn(MemberUtils.getDeclaredMembers(type)), (Predicate[])fieldFilters);
    }

    public static List<VariableElement> getDeclaredFields(TypeMirror type) {
        return FieldUtils.getDeclaredFields(type, Predicates.EMPTY_ARRAY);
    }

    public static List<VariableElement> getAllDeclaredFields(Element element, Predicate<VariableElement> ... fieldFilters) {
        return element == null ? Collections.emptyList() : FieldUtils.getAllDeclaredFields(element.asType(), fieldFilters);
    }

    public static List<VariableElement> getAllDeclaredFields(Element element) {
        return FieldUtils.getAllDeclaredFields(element, Predicates.EMPTY_ARRAY);
    }

    public static List<VariableElement> getAllDeclaredFields(TypeMirror type, Predicate<VariableElement> ... fieldFilters) {
        return TypeUtils.getHierarchicalTypes(type).stream().map(t -> FieldUtils.getDeclaredFields(t, fieldFilters)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<VariableElement> getAllDeclaredFields(TypeMirror type) {
        return FieldUtils.getAllDeclaredFields(type, Predicates.EMPTY_ARRAY);
    }

    public static VariableElement getDeclaredField(Element element, String fieldName) {
        return element == null ? null : FieldUtils.getDeclaredField(element.asType(), fieldName);
    }

    public static VariableElement getDeclaredField(TypeMirror type, String fieldName) {
        return (VariableElement)Streams.filterFirst(FieldUtils.getDeclaredFields(type, field -> fieldName.equals(field.getSimpleName().toString())), (Predicate[])new Predicate[0]);
    }

    public static VariableElement findField(Element element, String fieldName) {
        return element == null ? null : FieldUtils.findField(element.asType(), fieldName);
    }

    public static VariableElement findField(TypeMirror type, String fieldName) {
        return (VariableElement)Streams.filterFirst(FieldUtils.getAllDeclaredFields(type, field -> FieldUtils.equals(field, fieldName)), (Predicate[])new Predicate[0]);
    }

    public static boolean isEnumMemberField(VariableElement field) {
        if (field == null || !TypeUtils.isEnumType(field.getEnclosingElement())) {
            return false;
        }
        return ElementKind.ENUM_CONSTANT.equals((Object)field.getKind());
    }

    public static boolean isNonStaticField(VariableElement field) {
        return FieldUtils.isField(field) && !MemberUtils.hasModifiers(field, Modifier.STATIC);
    }

    public static boolean isField(VariableElement field) {
        return MemberUtils.matches(field, ElementKind.FIELD) || FieldUtils.isEnumMemberField(field);
    }

    public static boolean isField(VariableElement field, Modifier ... modifiers) {
        return FieldUtils.isField(field) && MemberUtils.hasModifiers(field, modifiers);
    }

    public static List<VariableElement> getNonStaticFields(TypeMirror type) {
        return FieldUtils.getDeclaredFields(type, FieldUtils::isNonStaticField);
    }

    public static List<VariableElement> getNonStaticFields(Element element) {
        return element == null ? Collections.emptyList() : FieldUtils.getNonStaticFields(element.asType());
    }

    public static List<VariableElement> getAllNonStaticFields(TypeMirror type) {
        return FieldUtils.getAllDeclaredFields(type, FieldUtils::isNonStaticField);
    }

    public static List<VariableElement> getAllNonStaticFields(Element element) {
        return element == null ? Collections.emptyList() : FieldUtils.getAllNonStaticFields(element.asType());
    }

    public static boolean equals(VariableElement field, CharSequence fieldName) {
        return field != null && fieldName != null && field.getSimpleName().toString().equals(fieldName.toString());
    }
}

