/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;
import org.apache.dubbo.common.function.Predicates;
import org.apache.dubbo.common.function.Streams;
import org.apache.dubbo.metadata.annotation.processing.util.TypeUtils;

public interface AnnotationUtils {
    public static AnnotationMirror getAnnotation(AnnotatedConstruct annotatedConstruct, Class<? extends Annotation> annotationClass) {
        return annotationClass == null ? null : AnnotationUtils.getAnnotation(annotatedConstruct, annotationClass.getTypeName());
    }

    public static AnnotationMirror getAnnotation(AnnotatedConstruct annotatedConstruct, CharSequence annotationClassName) {
        List<AnnotationMirror> annotations = AnnotationUtils.getAnnotations(annotatedConstruct, annotationClassName);
        return annotations.isEmpty() ? null : annotations.get(0);
    }

    public static List<AnnotationMirror> getAnnotations(AnnotatedConstruct annotatedConstruct, Class<? extends Annotation> annotationClass) {
        return annotationClass == null ? Collections.emptyList() : AnnotationUtils.getAnnotations(annotatedConstruct, annotationClass.getTypeName());
    }

    public static List<AnnotationMirror> getAnnotations(AnnotatedConstruct annotatedConstruct, CharSequence annotationClassName) {
        return AnnotationUtils.getAnnotations(annotatedConstruct, annotation -> TypeUtils.isSameType((TypeMirror)annotation.getAnnotationType(), annotationClassName));
    }

    public static List<AnnotationMirror> getAnnotations(AnnotatedConstruct annotatedConstruct) {
        return AnnotationUtils.getAnnotations(annotatedConstruct, Predicates.EMPTY_ARRAY);
    }

    public static List<AnnotationMirror> getAnnotations(AnnotatedConstruct annotatedConstruct, Predicate<AnnotationMirror> ... annotationFilters) {
        AnnotatedConstruct actualAnnotatedConstruct = annotatedConstruct;
        if (annotatedConstruct instanceof TypeMirror) {
            actualAnnotatedConstruct = TypeUtils.ofTypeElement((TypeMirror)actualAnnotatedConstruct);
        }
        return actualAnnotatedConstruct == null ? Collections.emptyList() : (List)Streams.filterAll(actualAnnotatedConstruct.getAnnotationMirrors(), (Predicate[])annotationFilters);
    }

    public static List<AnnotationMirror> getAllAnnotations(TypeMirror type) {
        return AnnotationUtils.getAllAnnotations(TypeUtils.ofTypeElement(type));
    }

    public static List<AnnotationMirror> getAllAnnotations(Element element) {
        return AnnotationUtils.getAllAnnotations(element, Predicates.EMPTY_ARRAY);
    }

    public static List<AnnotationMirror> getAllAnnotations(TypeMirror type, Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.getAllAnnotations((Element)TypeUtils.ofTypeElement(type), annotationClass);
    }

    public static List<AnnotationMirror> getAllAnnotations(Element element, Class<? extends Annotation> annotationClass) {
        return element == null || annotationClass == null ? Collections.emptyList() : AnnotationUtils.getAllAnnotations(element, (CharSequence)annotationClass.getTypeName());
    }

    public static List<AnnotationMirror> getAllAnnotations(TypeMirror type, CharSequence annotationClassName) {
        return AnnotationUtils.getAllAnnotations((Element)TypeUtils.ofTypeElement(type), annotationClassName);
    }

    public static List<AnnotationMirror> getAllAnnotations(Element element, CharSequence annotationClassName) {
        return AnnotationUtils.getAllAnnotations(element, annotation -> TypeUtils.isSameType((TypeMirror)annotation.getAnnotationType(), annotationClassName));
    }

    public static List<AnnotationMirror> getAllAnnotations(TypeMirror type, Predicate<AnnotationMirror> ... annotationFilters) {
        return AnnotationUtils.getAllAnnotations((Element)TypeUtils.ofTypeElement(type), annotationFilters);
    }

    public static List<AnnotationMirror> getAllAnnotations(Element element, Predicate<AnnotationMirror> ... annotationFilters) {
        List<Object> allAnnotations = TypeUtils.isTypeElement(element) ? TypeUtils.getHierarchicalTypes(TypeUtils.ofTypeElement(element)).stream().map(AnnotationUtils::getAnnotations).flatMap(Collection::stream).collect(Collectors.toList()) : (element == null ? Collections.emptyList() : element.getAnnotationMirrors());
        return (List)Streams.filterAll(allAnnotations, (Predicate[])annotationFilters);
    }

    public static List<AnnotationMirror> getAllAnnotations(ProcessingEnvironment processingEnv, Type annotatedType) {
        return AnnotationUtils.getAllAnnotations(processingEnv, annotatedType, Predicates.EMPTY_ARRAY);
    }

    public static List<AnnotationMirror> getAllAnnotations(ProcessingEnvironment processingEnv, Type annotatedType, Predicate<AnnotationMirror> ... annotationFilters) {
        return annotatedType == null ? Collections.emptyList() : AnnotationUtils.getAllAnnotations(processingEnv, annotatedType.getTypeName(), annotationFilters);
    }

    public static List<AnnotationMirror> getAllAnnotations(ProcessingEnvironment processingEnv, CharSequence annotatedTypeName, Predicate<AnnotationMirror> ... annotationFilters) {
        return AnnotationUtils.getAllAnnotations((Element)TypeUtils.getType(processingEnv, annotatedTypeName), annotationFilters);
    }

    public static AnnotationMirror findAnnotation(TypeMirror type, Class<? extends Annotation> annotationClass) {
        return annotationClass == null ? null : AnnotationUtils.findAnnotation(type, (CharSequence)annotationClass.getTypeName());
    }

    public static AnnotationMirror findAnnotation(TypeMirror type, CharSequence annotationClassName) {
        return AnnotationUtils.findAnnotation((Element)TypeUtils.ofTypeElement(type), annotationClassName);
    }

    public static AnnotationMirror findAnnotation(Element element, Class<? extends Annotation> annotationClass) {
        return annotationClass == null ? null : AnnotationUtils.findAnnotation(element, (CharSequence)annotationClass.getTypeName());
    }

    public static AnnotationMirror findAnnotation(Element element, CharSequence annotationClassName) {
        return (AnnotationMirror)Streams.filterFirst(AnnotationUtils.getAllAnnotations(element, annotation -> TypeUtils.isSameType((TypeMirror)annotation.getAnnotationType(), annotationClassName)), (Predicate[])new Predicate[0]);
    }

    public static AnnotationMirror findMetaAnnotation(Element annotatedConstruct, CharSequence metaAnnotationClassName) {
        return annotatedConstruct == null ? null : (AnnotationMirror)AnnotationUtils.getAnnotations(annotatedConstruct).stream().map(annotation -> AnnotationUtils.findAnnotation((TypeMirror)annotation.getAnnotationType(), metaAnnotationClassName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean isAnnotationPresent(Element element, CharSequence annotationClassName) {
        return AnnotationUtils.findAnnotation(element, annotationClassName) != null || AnnotationUtils.findMetaAnnotation(element, annotationClassName) != null;
    }

    public static <T> T getAttribute(AnnotationMirror annotation, String attributeName) {
        return annotation == null ? null : (T)AnnotationUtils.getAttribute(annotation.getElementValues(), attributeName);
    }

    public static <T> T getAttribute(Map<? extends ExecutableElement, ? extends AnnotationValue> attributesMap, String attributeName) {
        Object annotationValue = null;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : attributesMap.entrySet()) {
            ExecutableElement attributeMethod = entry.getKey();
            if (!Objects.equals(attributeName, attributeMethod.getSimpleName().toString())) continue;
            TypeMirror attributeType = attributeMethod.getReturnType();
            AnnotationValue value = entry.getValue();
            if (attributeType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)attributeType;
                String componentType = arrayType.getComponentType().toString();
                ClassLoader classLoader = AnnotationUtils.class.getClassLoader();
                List values = (List)value.getValue();
                int size = values.size();
                try {
                    Class<?> componentClass = classLoader.loadClass(componentType);
                    boolean isEnum = componentClass.isEnum();
                    Object array = Array.newInstance(componentClass, values.size());
                    for (int i = 0; i < size; ++i) {
                        Object element = ((AnnotationValue)values.get(i)).getValue();
                        if (isEnum) {
                            element = Enum.valueOf(componentClass, element.toString());
                        }
                        Array.set(array, i, element);
                    }
                    annotationValue = array;
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            annotationValue = value.getValue();
            break;
        }
        return (T)annotationValue;
    }

    public static <T> T getValue(AnnotationMirror annotation) {
        return AnnotationUtils.getAttribute(annotation, "value");
    }
}

