/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.metadata.rest.ArgInfo;
import org.apache.dubbo.metadata.rest.ParamType;

public class PathUtil {
    private static final String SEPARATOR = "/";

    public static String resolvePathVariable(String rawPath, List<ArgInfo> argInfos, List<Object> args) {
        String[] split = rawPath.split(SEPARATOR);
        List<String> strings = Arrays.asList(split);
        ArrayList<ArgInfo> pathArgInfos = new ArrayList<ArgInfo>();
        for (ArgInfo argInfo : argInfos) {
            if (!ParamType.PATH.supportAnno(argInfo.getParamAnnotationType())) continue;
            pathArgInfos.add(argInfo);
        }
        for (ArgInfo pathArgInfo : pathArgInfos) {
            strings.set(pathArgInfo.getUrlSplitIndex(), String.valueOf(args.get(pathArgInfo.getIndex())));
        }
        String pat = SEPARATOR;
        for (String string : strings) {
            if (string.length() == 0) continue;
            pat = pat + string + SEPARATOR;
        }
        if (pat.endsWith(SEPARATOR)) {
            pat = pat.substring(0, pat.lastIndexOf(SEPARATOR));
        }
        return pat;
    }

    public static void setArgInfoSplitIndex(String rawPath, List<ArgInfo> argInfos) {
        String[] split = rawPath.split(SEPARATOR);
        ArrayList<PathPair> pathPairs = new ArrayList<PathPair>();
        for (ArgInfo argInfo : argInfos) {
            if (!ParamType.PATH.supportAnno(argInfo.getParamAnnotationType())) continue;
            pathPairs.add(new PathPair(argInfo));
        }
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            for (PathPair pathPair : pathPairs) {
                boolean match = pathPair.match(s);
                if (!match) continue;
                pathPair.setArgInfoSplitIndex(i);
            }
        }
    }

    public static class PathPair {
        String value;
        ArgInfo argInfo;

        public PathPair(ArgInfo argInfo) {
            this.argInfo = argInfo;
            this.value = argInfo.getAnnotationNameAttribute();
        }

        public String getPatten() {
            return "{" + this.value + "}";
        }

        public String getLeftPatten() {
            return "{" + this.value;
        }

        public String getRightPatten() {
            return "}";
        }

        public boolean match(String value) {
            return this.getPatten().equals(value) || value.startsWith(this.getLeftPatten()) && value.endsWith(this.getRightPatten());
        }

        public String getValue() {
            return this.value;
        }

        public void setArgInfo(ArgInfo argInfo) {
            this.argInfo = argInfo;
        }

        public void setArgInfoSplitIndex(int urlSplitIndex) {
            this.argInfo.setUrlSplitIndex(urlSplitIndex);
        }
    }
}

