/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.maven.plugin.protoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;
import org.apache.dubbo.maven.plugin.protoc.DubboProtocPlugin;
import org.apache.dubbo.maven.plugin.protoc.DubboProtocPluginWrapper;
import org.apache.dubbo.maven.plugin.protoc.DubboProtocPluginWrapperFactory;
import org.apache.dubbo.maven.plugin.protoc.ProtocMetaData;
import org.apache.dubbo.maven.plugin.protoc.command.DefaultProtocCommandBuilder;
import org.apache.dubbo.maven.plugin.protoc.enums.DubboGenerateTypeEnum;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="compile", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class DubboProtocCompilerMojo
extends AbstractMojo {
    @Parameter(property="protoSourceDir", defaultValue="${basedir}/src/main/proto")
    private File protoSourceDir;
    @Parameter(property="outputDir", defaultValue="${project.build.directory}/generated-sources/protobuf/java")
    private File outputDir;
    @Parameter(required=false, property="dubboVersion")
    private String dubboVersion;
    @Parameter(required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(required=false, property="protocExecutable")
    private String protocExecutable;
    @Parameter(required=false, property="protocArtifact")
    private String protocArtifact;
    @Parameter(required=false, property="protocVersion")
    private String protocVersion;
    @Parameter(required=false, defaultValue="${project.build.directory}/protoc-plugins")
    private File protocPluginDirectory;
    @Parameter(required=true, defaultValue="${project.build.directory}/protoc-dependencies")
    private File temporaryProtoFileDirectory;
    @Parameter(required=true, property="dubboGenerateType", defaultValue="tri")
    private String dubboGenerateType;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(required=true, readonly=true, property="localRepository")
    private ArtifactRepository localRepository;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ResolutionErrorHandler resolutionErrorHandler;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected BuildContext buildContext;
    final CommandLineUtils.StringStreamConsumer output = new CommandLineUtils.StringStreamConsumer();
    final CommandLineUtils.StringStreamConsumer error = new CommandLineUtils.StringStreamConsumer();
    private final DefaultProtocCommandBuilder defaultProtocCommandBuilder = new DefaultProtocCommandBuilder();
    private final DubboProtocPluginWrapperFactory dubboProtocPluginWrapperFactory = new DubboProtocPluginWrapperFactory();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties versionMatrix = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try (InputStream stream = loader.getResourceAsStream("version-matrix.properties");){
            versionMatrix.load(stream);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Unable to load default version matrix", (Throwable)e);
        }
        if (this.dubboVersion == null) {
            this.dubboVersion = versionMatrix.getProperty("dubbo.version");
        }
        if (this.protocVersion == null) {
            this.protocVersion = versionMatrix.getProperty("protoc.version");
        }
        if (this.protocArtifact == null) {
            String osName = SystemPropertyConfigUtils.getSystemProperty((String)"os.name");
            String osArch = SystemPropertyConfigUtils.getSystemProperty((String)"os.arch");
            String detectedName = DubboProtocCompilerMojo.normalizeOs(osName);
            String detectedArch = DubboProtocCompilerMojo.normalizeArch(osArch);
            this.protocArtifact = "com.google.protobuf:protoc:" + this.protocVersion + ":exe:" + detectedName + '-' + detectedArch;
        }
        if (this.protocExecutable == null && this.protocArtifact != null) {
            Artifact artifact = this.createProtocArtifact(this.protocArtifact);
            File file = this.resolveBinaryArtifact(artifact);
            this.protocExecutable = file.getAbsolutePath();
        }
        if (this.protocExecutable == null) {
            this.getLog().warn((CharSequence)"No 'protocExecutable' parameter is configured, using the default: 'protoc'");
            this.protocExecutable = "protoc";
        }
        this.getLog().info((CharSequence)("using protocExecutable: " + this.protocExecutable));
        DubboProtocPlugin dubboProtocPlugin = this.buildDubboProtocPlugin(this.dubboVersion, this.dubboGenerateType, this.protocPluginDirectory);
        this.getLog().info((CharSequence)("build dubbo protoc plugin:" + dubboProtocPlugin + " success"));
        List<String> commandArgs = this.defaultProtocCommandBuilder.buildProtocCommandArgs(new ProtocMetaData(this.protocExecutable, this.makeAllProtoPaths(), this.findAllProtoFiles(this.protoSourceDir), this.outputDir, dubboProtocPlugin));
        if (!this.outputDir.exists()) {
            FileUtils.mkdir((String)this.outputDir.getAbsolutePath());
        }
        try {
            int exitStatus = this.executeCommandLine(commandArgs);
            this.getLog().info((CharSequence)("execute commandLine finished with exit code: " + exitStatus));
            if (exitStatus != 0) {
                this.getLog().error((CharSequence)("PROTOC FAILED: " + this.getError()));
                throw new MojoFailureException("protoc did not exit cleanly. Review output for more information.");
            }
            if (StringUtils.isNotBlank((String)this.getError())) {
                this.getLog().warn((CharSequence)("PROTOC: " + this.getError()));
            }
            this.linkProtoFilesToMaven();
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private static String normalizeOs(String value) {
        if ((value = DubboProtocCompilerMojo.normalize(value)).startsWith("linux")) {
            return "linux";
        }
        if (value.startsWith("mac") || value.startsWith("osx")) {
            return "osx";
        }
        if (value.startsWith("windows")) {
            return "windows";
        }
        return "unknown";
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private static String normalizeArch(String value) {
        if ((value = DubboProtocCompilerMojo.normalize(value)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if ("aarch64".equals(value)) {
            return "aarch_64";
        }
        return "unknown";
    }

    public void linkProtoFilesToMaven() {
        this.linkProtoSources();
        this.linkGeneratedFiles();
    }

    public void linkProtoSources() {
        this.projectHelper.addResource(this.project, this.protoSourceDir.getAbsolutePath(), Collections.singletonList("**/*.proto*"), Collections.singletonList(""));
    }

    public void linkGeneratedFiles() {
        this.project.addCompileSourceRoot(this.outputDir.getAbsolutePath());
        this.buildContext.refresh(this.outputDir);
    }

    public List<File> findAllProtoFiles(File protoSourceDir) {
        List protoFilesInDirectory;
        if (protoSourceDir == null) {
            throw new RuntimeException("'protoSourceDir' is null");
        }
        if (!protoSourceDir.isDirectory()) {
            throw new RuntimeException(String.format("%s is not a directory", protoSourceDir));
        }
        try {
            protoFilesInDirectory = FileUtils.getFiles((File)protoSourceDir, (String)"**/*.proto*", (String)"");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to retrieve the list of files: " + e.getMessage(), e);
        }
        this.getLog().info((CharSequence)("protoFilesInDirectory: " + protoFilesInDirectory));
        return protoFilesInDirectory;
    }

    public int executeCommandLine(List<String> commandArgs) throws CommandLineException {
        Commandline cl = new Commandline();
        cl.setExecutable(this.protocExecutable);
        cl.addArguments(commandArgs.toArray(new String[0]));
        int attemptsLeft = 3;
        while (true) {
            try {
                this.getLog().info((CharSequence)("commandLine:" + cl.toString()));
                return CommandLineUtils.executeCommandLine((Commandline)cl, null, (StreamConsumer)this.output, (StreamConsumer)this.error);
            }
            catch (CommandLineException e) {
                if (--attemptsLeft == 0 || e.getCause() == null) {
                    throw e;
                }
                this.getLog().warn((CharSequence)("[PROTOC] Unable to invoke protoc, will retry " + attemptsLeft + " time(s)"), (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private DubboProtocPlugin buildDubboProtocPlugin(String dubboVersion, String dubboGenerateType, File protocPluginDirectory) {
        DubboProtocPlugin dubboProtocPlugin = new DubboProtocPlugin();
        DubboGenerateTypeEnum dubboGenerateTypeEnum = DubboGenerateTypeEnum.getByType(dubboGenerateType);
        if (dubboGenerateTypeEnum == null) {
            throw new RuntimeException(" can not find the dubboGenerateType: " + dubboGenerateType + ",please check it !");
        }
        dubboProtocPlugin.setId(dubboGenerateType);
        dubboProtocPlugin.setMainClass(dubboGenerateTypeEnum.getMainClass());
        dubboProtocPlugin.setDubboVersion(dubboVersion);
        dubboProtocPlugin.setPluginDirectory(protocPluginDirectory);
        dubboProtocPlugin.setJavaHome(SystemPropertyConfigUtils.getSystemProperty((String)"java.home"));
        DubboProtocPluginWrapper protocPluginWrapper = this.dubboProtocPluginWrapperFactory.findByOs();
        dubboProtocPlugin.setResolvedJars(this.resolvePluginDependencies());
        File protocPlugin = protocPluginWrapper.createProtocPlugin(dubboProtocPlugin, this.getLog());
        boolean debugEnabled = this.getLog().isDebugEnabled();
        if (debugEnabled) {
            this.getLog().debug((CharSequence)("protocPlugin: " + protocPlugin.getAbsolutePath()));
        }
        dubboProtocPlugin.setProtocPlugin(protocPlugin);
        return dubboProtocPlugin;
    }

    private List<File> resolvePluginDependencies() {
        VersionRange versionSpec;
        ArrayList<File> resolvedJars = new ArrayList<File>();
        try {
            versionSpec = VersionRange.createFromVersionSpec((String)this.dubboVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException("Invalid plugin version specification", e);
        }
        Artifact protocPluginArtifact = this.artifactFactory.createDependencyArtifact("org.apache.dubbo", "dubbo-compiler", versionSpec, "jar", "", "runtime");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(this.project.getArtifact()).setResolveRoot(false).setArtifactDependencies(Collections.singleton(protocPluginArtifact)).setManagedVersionMap(Collections.emptyMap()).setLocalRepository(this.localRepository).setRemoteRepositories(this.remoteRepositories).setOffline(this.session.isOffline()).setForceUpdate(this.session.getRequest().isUpdateSnapshots()).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        try {
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException("Unable to resolve plugin artifact: " + e.getMessage(), e);
        }
        Set artifacts = result.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            throw new RuntimeException("Unable to resolve plugin artifact");
        }
        for (Artifact artifact : artifacts) {
            resolvedJars.add(artifact.getFile());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolved jars: " + resolvedJars));
        }
        return resolvedJars;
    }

    protected Artifact createProtocArtifact(String artifactSpec) {
        Object[] parts = artifactSpec.split(":");
        if (parts.length < 3 || parts.length > 5) {
            throw new RuntimeException("Invalid artifact specification format, expected: groupId:artifactId:version[:type[:classifier]], actual: " + artifactSpec);
        }
        String type = parts.length >= 4 ? parts[3] : "exe";
        String classifier = parts.length == 5 ? parts[4] : null;
        this.getLog().info((CharSequence)("parts: " + Arrays.toString(parts)));
        return this.createDependencyArtifact((String)parts[0], (String)parts[1], (String)parts[2], type, classifier);
    }

    protected Artifact createDependencyArtifact(String groupId, String artifactId, String version, String type, String classifier) {
        VersionRange versionSpec;
        try {
            versionSpec = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException("Invalid version specification", e);
        }
        return this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionSpec, type, classifier, "runtime");
    }

    protected File resolveBinaryArtifact(Artifact artifact) {
        boolean b;
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(this.project.getArtifact()).setResolveRoot(false).setResolveTransitively(false).setArtifactDependencies(Collections.singleton(artifact)).setManagedVersionMap(Collections.emptyMap()).setLocalRepository(this.localRepository).setRemoteRepositories(this.remoteRepositories).setOffline(this.session.isOffline()).setForceUpdate(this.session.getRequest().isUpdateSnapshots()).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        try {
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException("Unable to resolve artifact: " + e.getMessage(), e);
        }
        Set artifacts = result.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            throw new RuntimeException("Unable to resolve artifact");
        }
        Artifact resolvedBinaryArtifact = (Artifact)artifacts.iterator().next();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Resolved artifact: " + resolvedBinaryArtifact));
        }
        File sourceFile = resolvedBinaryArtifact.getFile();
        String sourceFileName = sourceFile.getName();
        String targetFileName = Os.isFamily((String)"windows") && !sourceFileName.endsWith(".exe") ? sourceFileName + ".exe" : sourceFileName;
        File targetFile = new File(this.protocPluginDirectory, targetFileName);
        if (targetFile.exists()) {
            this.getLog().debug((CharSequence)("Executable file already exists: " + targetFile.getAbsolutePath()));
            return targetFile;
        }
        try {
            FileUtils.forceMkdir((File)this.protocPluginDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create directory " + this.protocPluginDirectory, e);
        }
        try {
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy the file to " + this.protocPluginDirectory, e);
        }
        if (!Os.isFamily((String)"windows") && !(b = targetFile.setExecutable(true))) {
            throw new RuntimeException("Unable to make executable: " + targetFile.getAbsolutePath());
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Executable file: " + targetFile.getAbsolutePath()));
        }
        return targetFile;
    }

    protected Set<File> makeAllProtoPaths() {
        File temp = this.temporaryProtoFileDirectory;
        if (temp.exists()) {
            try {
                FileUtils.cleanDirectory((File)temp);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to clean up temporary proto file directory", e);
            }
        }
        LinkedHashSet<File> protoDirectories = new LinkedHashSet<File>();
        if (this.protoSourceDir.exists()) {
            protoDirectories.add(this.protoSourceDir);
        }
        for (Artifact artifact : this.project.getCompileArtifacts()) {
            List protoFiles;
            File file = artifact.getFile();
            if (file.isFile() && file.canRead() && !file.getName().endsWith(".xml")) {
                try {
                    JarFile jar = new JarFile(file);
                    try {
                        Enumeration<JarEntry> jarEntries = jar.entries();
                        while (jarEntries.hasMoreElements()) {
                            File targetDirectory;
                            JarEntry jarEntry = jarEntries.nextElement();
                            String jarEntryName = jarEntry.getName();
                            if (!jarEntryName.endsWith(".proto")) continue;
                            try {
                                targetDirectory = new File(temp, DubboProtocCompilerMojo.hash(jar.getName()));
                                String canonicalTargetDirectoryPath = targetDirectory.getCanonicalPath();
                                File target = new File(targetDirectory, jarEntryName);
                                String canonicalTargetPath = target.getCanonicalPath();
                                if (!canonicalTargetPath.startsWith(canonicalTargetDirectoryPath + File.separator)) {
                                    throw new RuntimeException("ZIP SLIP: Entry " + jarEntry.getName() + " in " + jar.getName() + " is outside of the target dir");
                                }
                                FileUtils.mkdir((String)target.getParentFile().getAbsolutePath());
                                FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(jar.getInputStream(jarEntry)), (File)target);
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Unable to unpack proto files", e);
                            }
                            protoDirectories.add(targetDirectory);
                        }
                        continue;
                    }
                    finally {
                        jar.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Not a readable JAR artifact: " + file.getAbsolutePath(), e);
                }
            }
            if (!file.isDirectory()) continue;
            try {
                protoFiles = FileUtils.getFiles((File)file, (String)"**/*.proto", null);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to scan for proto files in: " + file.getAbsolutePath(), e);
            }
            if (protoFiles.isEmpty()) continue;
            protoDirectories.add(file);
        }
        return protoDirectories;
    }

    private static String hash(String input) {
        try {
            byte[] bytes = MessageDigest.getInstance("MD5").digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder(32);
            for (byte b : bytes) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create MD5 digest", e);
        }
    }

    public String getError() {
        return DubboProtocCompilerMojo.fixUnicodeOutput(this.error.getOutput());
    }

    public String getOutput() {
        return DubboProtocCompilerMojo.fixUnicodeOutput(this.output.getOutput());
    }

    private static String fixUnicodeOutput(String message) {
        return new String(message.getBytes(), StandardCharsets.UTF_8);
    }
}

