/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring6.beans.factory.annotation;

import java.util.Collection;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServiceAnnotationPostProcessor;
import org.apache.dubbo.config.spring6.utils.AotUtils;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class ServiceAnnotationWithAotPostProcessor
extends ServiceAnnotationPostProcessor
implements BeanRegistrationAotProcessor {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(((Object)((Object)this)).getClass());

    public ServiceAnnotationWithAotPostProcessor(String ... packagesToScan) {
        super(packagesToScan);
    }

    public ServiceAnnotationWithAotPostProcessor(Collection<?> packagesToScan) {
        super(packagesToScan);
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class beanClass = registeredBean.getBeanClass();
        if (beanClass.equals(ServiceBean.class)) {
            RootBeanDefinition beanDefinition = registeredBean.getMergedBeanDefinition();
            String interfaceName = (String)beanDefinition.getPropertyValues().get("interface");
            try {
                Class<?> c = Class.forName(interfaceName);
                return new DubboServiceBeanRegistrationAotContribution(c);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.servicePackagesHolder.isClassScanned(beanClass.getName())) {
            return new DubboServiceBeanRegistrationAotContribution(beanClass);
        }
        return null;
    }

    private static class DubboServiceBeanRegistrationAotContribution
    implements BeanRegistrationAotContribution {
        private final Class<?> cl;

        public DubboServiceBeanRegistrationAotContribution(Class<?> cl) {
            this.cl = cl;
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            generationContext.getRuntimeHints().reflection().registerType(TypeReference.of(this.cl), new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
            AotUtils.registerSerializationForService(this.cl, generationContext.getRuntimeHints());
        }
    }
}

