/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import java.util.SortedMap;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.config.spring.context.DubboSpringInitializer;
import org.apache.dubbo.config.spring.extension.SpringExtensionInjector;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.config.spring.util.EnvironmentUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class DubboContextPostProcessor
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware,
EnvironmentAware {
    public static final String BEAN_NAME = "dubboContextPostProcessor";
    private ApplicationContext applicationContext;
    private ConfigurableEnvironment environment;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ApplicationModel applicationModel = DubboBeanUtils.getApplicationModel((BeanFactory)beanFactory);
        ModuleModel moduleModel = DubboBeanUtils.getModuleModel((BeanFactory)beanFactory);
        SpringExtensionInjector.get((ExtensionAccessor)applicationModel).init(this.applicationContext);
        SpringExtensionInjector.get((ExtensionAccessor)moduleModel).init(this.applicationContext);
        DubboBeanUtils.getInitializationContext((BeanFactory)beanFactory).setApplicationContext(this.applicationContext);
        SortedMap<String, String> dubboProperties = EnvironmentUtils.filterDubboProperties(this.environment);
        applicationModel.getModelEnvironment().getAppConfigMap().putAll(dubboProperties);
        beanFactory.registerSingleton("dubboConfigManager", (Object)applicationModel.getApplicationConfigManager());
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        DubboSpringInitializer.initialize(beanDefinitionRegistry);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }
}

