/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;

public class LockUtils {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(LockUtils.class);
    public static final int DEFAULT_TIMEOUT = 60000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safeLock(Lock lock, int timeout, Runnable runnable) {
        try {
            boolean interrupted = false;
            try {
                if (!lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                    logger.error("99-0", "", "", "Try to lock failed, timeout: " + timeout, new TimeoutException());
                }
            }
            catch (InterruptedException e) {
                logger.warn("99-0", "", "", "Try to lock failed", e);
                interrupted = true;
            }
            runnable.run();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            try {
                lock.unlock();
            }
            catch (Exception exception) {}
        }
    }
}

