/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.logger;

import java.util.function.Supplier;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.FluentLogger;
import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.logger.helpers.FormattingTuple;
import org.apache.dubbo.common.logger.helpers.MessageFormatter;

final class FluentLoggerImpl
implements FluentLogger {
    private final ErrorTypeAwareLogger delegate;
    private final FluentLoggerImpl root;
    private String cause = "";
    private String extendedInformation = "";
    private Supplier<String> messageSupplier;
    private String message;
    private Object[] args;

    FluentLoggerImpl(Class<?> key) {
        this.delegate = LoggerFactory.getErrorTypeAwareLogger(FluentLoggerImpl.class.getName(), key);
        this.root = this;
    }

    FluentLoggerImpl(String key) {
        this.delegate = LoggerFactory.getErrorTypeAwareLogger(FluentLoggerImpl.class.getName(), key);
        this.root = this;
    }

    private FluentLoggerImpl(FluentLoggerImpl logger) {
        this.delegate = logger.delegate;
        this.root = logger;
    }

    @Override
    public FluentLogger cause(String cause) {
        if (cause == null) {
            return this;
        }
        FluentLoggerImpl logger = this.getLogger();
        logger.cause = cause;
        return logger;
    }

    @Override
    public FluentLogger more(String extendedInformation) {
        if (extendedInformation == null) {
            return this;
        }
        FluentLoggerImpl logger = this.getLogger();
        logger.extendedInformation = extendedInformation;
        return logger;
    }

    @Override
    public FluentLogger msg(String message) {
        FluentLoggerImpl logger = this.getLogger();
        logger.message = message;
        return logger;
    }

    @Override
    public FluentLogger msg(String message, Object ... args) {
        FluentLoggerImpl logger = this.getLogger();
        logger.message = message;
        logger.args = args;
        return logger;
    }

    @Override
    public FluentLogger msg(Supplier<String> supplier) {
        FluentLoggerImpl logger = this.getLogger();
        logger.messageSupplier = supplier;
        return logger;
    }

    @Override
    public void trace() {
        if (this.message != null) {
            if (this.args != null && this.args.length > 0) {
                if (this.delegate.isTraceEnabled()) {
                    this.delegate.trace(this.message, FluentLoggerImpl.formatArgs(this.args));
                }
            } else {
                this.delegate.trace(this.message);
            }
        } else if (this.messageSupplier != null) {
            if (this.delegate.isTraceEnabled()) {
                this.delegate.trace(this.messageSupplier.get());
            }
        } else {
            this.warnMessageMissing();
        }
    }

    @Override
    public void trace(Throwable t) {
        if (this.message != null) {
            int len;
            int n = len = this.args == null ? 0 : this.args.length;
            if (len > 0) {
                if (this.delegate.isTraceEnabled()) {
                    Object[] arr = new Object[len + 1];
                    System.arraycopy(this.args, 0, arr, 0, len);
                    arr[len] = t;
                    this.delegate.trace(this.message, FluentLoggerImpl.formatArgs(arr));
                }
            } else {
                this.delegate.trace(this.message, t);
            }
        } else if (this.messageSupplier != null) {
            if (this.delegate.isTraceEnabled()) {
                this.delegate.trace(this.messageSupplier.get(), t);
            }
        } else {
            this.warnMessageMissing();
        }
    }

    @Override
    public void trace(String message) {
        this.delegate.trace(message);
    }

    @Override
    public void trace(String message, Object ... args) {
        if (args == null || args.length == 0) {
            this.delegate.trace(message);
        } else if (this.delegate.isTraceEnabled()) {
            this.delegate.trace(message, FluentLoggerImpl.formatArgs(args));
        }
    }

    @Override
    public void trace(String message, Throwable t) {
        this.delegate.trace(message, t);
    }

    @Override
    public void debug() {
        if (this.message != null) {
            if (this.args != null && this.args.length > 0) {
                if (this.delegate.isDebugEnabled()) {
                    this.delegate.debug(this.message, FluentLoggerImpl.formatArgs(this.args));
                }
            } else {
                this.delegate.debug(this.message);
            }
        } else if (this.messageSupplier != null) {
            if (this.delegate.isDebugEnabled()) {
                this.delegate.debug(this.messageSupplier.get());
            }
        } else {
            this.warnMessageMissing();
        }
    }

    @Override
    public void debug(Throwable t) {
        if (this.message != null) {
            int len;
            int n = len = this.args == null ? 0 : this.args.length;
            if (len > 0) {
                if (this.delegate.isDebugEnabled()) {
                    Object[] arr = new Object[len + 1];
                    System.arraycopy(this.args, 0, arr, 0, len);
                    arr[len] = t;
                    this.delegate.debug(this.message, FluentLoggerImpl.formatArgs(arr));
                }
            } else {
                this.delegate.debug(this.message, t);
            }
        } else if (this.messageSupplier != null) {
            if (this.delegate.isDebugEnabled()) {
                this.delegate.debug(this.messageSupplier.get(), t);
            }
        } else {
            this.warnMessageMissing();
        }
    }

    @Override
    public void debug(String message) {
        this.delegate.debug(message);
    }

    @Override
    public void debug(String message, Object ... args) {
        if (args == null || args.length == 0) {
            this.delegate.debug(message);
        } else if (this.delegate.isDebugEnabled()) {
            this.delegate.debug(message, FluentLoggerImpl.formatArgs(args));
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        this.delegate.debug(message, t);
    }

    @Override
    public void info() {
        if (this.message != null) {
            if (this.args != null && this.args.length > 0) {
                if (this.delegate.isInfoEnabled()) {
                    this.delegate.info(this.message, FluentLoggerImpl.formatArgs(this.args));
                }
            } else {
                this.delegate.info(this.message);
            }
        } else if (this.messageSupplier != null) {
            if (this.delegate.isInfoEnabled()) {
                this.delegate.info(this.messageSupplier.get());
            }
        } else {
            this.warnMessageMissing();
        }
    }

    @Override
    public void info(Throwable t) {
        if (this.message != null) {
            int len;
            int n = len = this.args == null ? 0 : this.args.length;
            if (len > 0) {
                if (this.delegate.isInfoEnabled()) {
                    Object[] arr = new Object[len + 1];
                    System.arraycopy(this.args, 0, arr, 0, len);
                    arr[len] = t;
                    this.delegate.info(this.message, FluentLoggerImpl.formatArgs(arr));
                }
            } else {
                this.delegate.info(this.message, t);
            }
        } else if (this.messageSupplier != null) {
            if (this.delegate.isInfoEnabled()) {
                this.delegate.info(this.messageSupplier.get(), t);
            }
        } else {
            this.warnMessageMissing();
        }
    }

    @Override
    public void info(String message, Object ... args) {
        if (args == null || args.length == 0) {
            this.delegate.info(message);
        } else if (this.delegate.isInfoEnabled()) {
            this.delegate.info(message, FluentLoggerImpl.formatArgs(args));
        }
    }

    @Override
    public void info(String message) {
        this.delegate.info(message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.delegate.info(message, t);
    }

    @Override
    public void internalWarn() {
        this.warn("99-0");
    }

    @Override
    public void internalWarn(Throwable t) {
        this.warn("99-0", t);
    }

    @Override
    public void internalWarn(String message) {
        this.warn("99-0", message, new Object[0]);
    }

    @Override
    public void internalWarn(String message, Object ... args) {
        this.warn("99-0", message, args);
    }

    @Override
    public void internalWarn(String message, Throwable t) {
        this.warn("99-0", message, t);
    }

    @Override
    public void warn(String code) {
        if (this.message != null) {
            if (this.args != null && this.args.length > 0) {
                this.formatAndWarn(code, this.message, this.args);
            } else {
                this.delegate.warn(code, this.cause, this.extendedInformation, this.message);
            }
        } else if (this.messageSupplier != null) {
            if (this.delegate.isWarnEnabled()) {
                this.delegate.warn(code, this.cause, this.extendedInformation, this.messageSupplier.get());
            }
        } else {
            this.warnMessageMissing();
        }
    }

    @Override
    public void warn(String code, Throwable t) {
        if (this.message != null) {
            if (this.args != null && this.args.length > 0) {
                if (this.delegate.isWarnEnabled()) {
                    FormattingTuple tuple = MessageFormatter.arrayFormat(this.message, FluentLoggerImpl.formatArgs(this.args));
                    this.delegate.warn(code, this.cause, this.extendedInformation, tuple.getMessage(), t);
                }
            } else {
                this.delegate.warn(code, this.cause, this.extendedInformation, this.message, t);
            }
        } else if (this.messageSupplier != null && this.delegate.isWarnEnabled()) {
            this.delegate.warn(code, this.cause, this.extendedInformation, this.messageSupplier.get(), t);
        }
    }

    @Override
    public void warn(String code, String message, Object ... args) {
        if (args == null || args.length == 0) {
            this.delegate.warn(code, this.cause, this.extendedInformation, message);
            return;
        }
        this.formatAndWarn(code, message, args);
    }

    private void formatAndWarn(String code, String message, Object ... args) {
        if (!this.delegate.isWarnEnabled()) {
            return;
        }
        FormattingTuple tuple = MessageFormatter.arrayFormat(message, FluentLoggerImpl.formatArgs(args));
        if (tuple.getThrowable() == null) {
            this.delegate.warn(code, this.cause, this.extendedInformation, tuple.getMessage());
        } else {
            this.delegate.warn(code, this.cause, this.extendedInformation, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void warn(String code, String message, Throwable t) {
        this.delegate.warn(code, this.cause, this.extendedInformation, message, t);
    }

    @Override
    public void internalError() {
        this.error("99-0");
    }

    @Override
    public void internalError(Throwable t) {
        this.error("99-0", t);
    }

    @Override
    public void internalError(String message) {
        this.error("99-0", message, new Object[0]);
    }

    @Override
    public void internalError(String message, Object ... args) {
        this.error("99-0", message, args);
    }

    @Override
    public void internalError(String message, Throwable t) {
        this.error("99-0", message, t);
    }

    @Override
    public void error(String code) {
        if (this.message != null) {
            if (this.args != null && this.args.length > 0) {
                this.formatAndError(code, this.message, this.args);
            } else {
                this.delegate.error(code, this.cause, this.extendedInformation, this.message);
            }
        } else if (this.messageSupplier != null) {
            if (this.delegate.isErrorEnabled()) {
                this.delegate.error(code, this.cause, this.extendedInformation, this.messageSupplier.get());
            }
        } else {
            this.warnMessageMissing();
        }
    }

    @Override
    public void error(String code, Throwable t) {
        if (this.message != null) {
            if (this.args != null && this.args.length > 0) {
                if (this.delegate.isErrorEnabled()) {
                    FormattingTuple tuple = MessageFormatter.arrayFormat(this.message, FluentLoggerImpl.formatArgs(this.args));
                    this.delegate.error(code, this.cause, this.extendedInformation, tuple.getMessage(), t);
                }
            } else {
                this.delegate.error(code, this.cause, this.extendedInformation, this.message, t);
            }
        } else if (this.messageSupplier != null) {
            if (this.delegate.isErrorEnabled()) {
                this.delegate.error(code, this.cause, this.extendedInformation, this.messageSupplier.get(), t);
            }
        } else {
            this.warnMessageMissing();
        }
    }

    @Override
    public void error(String code, String message, Object ... args) {
        if (args == null || args.length == 0) {
            this.delegate.error(code, this.cause, this.extendedInformation, message);
            return;
        }
        this.formatAndError(code, message, args);
    }

    private void formatAndError(String code, String message, Object ... args) {
        if (!this.delegate.isErrorEnabled()) {
            return;
        }
        FormattingTuple tuple = MessageFormatter.arrayFormat(message, FluentLoggerImpl.formatArgs(args));
        if (tuple.getThrowable() == null) {
            this.delegate.error(code, this.cause, this.extendedInformation, tuple.getMessage());
        } else {
            this.delegate.error(code, this.cause, this.extendedInformation, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void error(String code, String message, Throwable t) {
        this.delegate.error(code, this.cause, this.extendedInformation, message, t);
    }

    @Override
    public void log(Level level) {
        switch (level) {
            case TRACE: {
                this.trace();
                break;
            }
            case DEBUG: {
                this.debug();
                break;
            }
            case INFO: {
                this.info();
                break;
            }
            case WARN: {
                this.internalWarn();
                break;
            }
            case ERROR: {
                this.internalError();
                break;
            }
        }
    }

    @Override
    public void log(Level level, Throwable t) {
        switch (level) {
            case TRACE: {
                this.trace(t);
                break;
            }
            case DEBUG: {
                this.debug(t);
                break;
            }
            case INFO: {
                this.info(t);
                break;
            }
            case WARN: {
                this.internalWarn(t);
                break;
            }
            case ERROR: {
                this.internalError(t);
                break;
            }
        }
    }

    @Override
    public void log(Level level, String msg) {
        switch (level) {
            case TRACE: {
                this.trace(msg);
                break;
            }
            case DEBUG: {
                this.debug(msg);
                break;
            }
            case INFO: {
                this.info(msg);
                break;
            }
            case WARN: {
                this.internalWarn(msg);
                break;
            }
            case ERROR: {
                this.internalError(msg);
                break;
            }
        }
    }

    @Override
    public void log(Level level, String msg, Object ... args) {
        switch (level) {
            case TRACE: {
                this.trace(msg, args);
                break;
            }
            case DEBUG: {
                this.debug(msg, args);
                break;
            }
            case INFO: {
                this.info(msg, args);
                break;
            }
            case WARN: {
                this.internalWarn(msg, args);
                break;
            }
            case ERROR: {
                this.internalError(msg, args);
                break;
            }
        }
    }

    @Override
    public void log(Level level, String msg, Throwable t) {
        switch (level) {
            case TRACE: {
                this.trace(msg, t);
                break;
            }
            case DEBUG: {
                this.debug(msg, t);
                break;
            }
            case INFO: {
                this.info(msg, t);
                break;
            }
            case WARN: {
                this.internalWarn(msg, t);
                break;
            }
            case ERROR: {
                this.internalError(msg, t);
                break;
            }
        }
    }

    @Override
    public void log(String code, Level level) {
        switch (level) {
            case TRACE: {
                this.trace();
                break;
            }
            case DEBUG: {
                this.debug();
                break;
            }
            case INFO: {
                this.info();
                break;
            }
            case WARN: {
                this.warn(code);
                break;
            }
            case ERROR: {
                this.error(code);
                break;
            }
        }
    }

    @Override
    public void log(String code, Level level, String msg, Object ... args) {
        switch (level) {
            case TRACE: {
                this.trace(msg, args);
                break;
            }
            case DEBUG: {
                this.debug(msg, args);
                break;
            }
            case INFO: {
                this.info(msg, args);
                break;
            }
            case WARN: {
                this.warn(code, msg, args);
                break;
            }
            case ERROR: {
                this.error(code, msg, args);
                break;
            }
        }
    }

    @Override
    public void log(String code, Level level, String msg, Throwable t) {
        switch (level) {
            case TRACE: {
                this.trace(msg, t);
                break;
            }
            case DEBUG: {
                this.debug(msg, t);
                break;
            }
            case INFO: {
                this.info(msg, t);
                break;
            }
            case WARN: {
                this.warn(code, msg, t);
                break;
            }
            case ERROR: {
                this.error(code, msg, t);
                break;
            }
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    private FluentLoggerImpl getLogger() {
        return this == this.root ? new FluentLoggerImpl(this) : this;
    }

    private void warnMessageMissing() {
        this.delegate.warn("99-0", this.cause, this.extendedInformation, "Message must not be empty");
    }

    private static Object[] formatArgs(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Supplier)) continue;
            args[i] = ((Supplier)args[i]).get();
        }
        return args;
    }
}

