/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.logger.support;

import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.utils.NetUtils;

public class FailsafeLogger
implements Logger {
    private Logger logger;
    private static boolean disabled = false;

    public FailsafeLogger(Logger logger) {
        this.logger = logger;
    }

    public static void setDisabled(boolean disabled) {
        FailsafeLogger.disabled = disabled;
    }

    static boolean getDisabled() {
        return disabled;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private String appendContextMessage(String msg) {
        return " [DUBBO] " + msg + ", dubbo version: " + Version.getVersion() + ", current host: " + NetUtils.getLocalHost();
    }

    @Override
    public void trace(String msg, Throwable e) {
        if (disabled || !this.logger.isTraceEnabled()) {
            return;
        }
        try {
            this.logger.trace(this.appendContextMessage(msg), e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void trace(Throwable e) {
        if (disabled || !this.logger.isTraceEnabled()) {
            return;
        }
        try {
            this.logger.trace(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void trace(String msg) {
        if (disabled || !this.logger.isTraceEnabled()) {
            return;
        }
        try {
            this.logger.trace(this.appendContextMessage(msg));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        if (disabled || !this.logger.isTraceEnabled()) {
            return;
        }
        try {
            this.logger.trace(this.appendContextMessage(msg), arguments);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void debug(String msg, Throwable e) {
        if (disabled || !this.logger.isDebugEnabled()) {
            return;
        }
        try {
            this.logger.debug(this.appendContextMessage(msg), e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void debug(Throwable e) {
        if (disabled || !this.logger.isDebugEnabled()) {
            return;
        }
        try {
            this.logger.debug(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void debug(String msg) {
        if (disabled || !this.logger.isDebugEnabled()) {
            return;
        }
        try {
            this.logger.debug(this.appendContextMessage(msg));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        if (disabled || !this.logger.isDebugEnabled()) {
            return;
        }
        try {
            this.logger.debug(this.appendContextMessage(msg), arguments);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void info(String msg, Throwable e) {
        if (disabled || !this.logger.isInfoEnabled()) {
            return;
        }
        try {
            this.logger.info(this.appendContextMessage(msg), e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void info(String msg) {
        if (disabled || !this.logger.isInfoEnabled()) {
            return;
        }
        try {
            this.logger.info(this.appendContextMessage(msg));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void info(String msg, Object ... arguments) {
        if (disabled || !this.logger.isInfoEnabled()) {
            return;
        }
        try {
            this.logger.info(this.appendContextMessage(msg), arguments);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void warn(String msg, Throwable e) {
        if (disabled || !this.logger.isWarnEnabled()) {
            return;
        }
        try {
            this.logger.warn(this.appendContextMessage(msg), e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void warn(String msg) {
        if (disabled || !this.logger.isWarnEnabled()) {
            return;
        }
        try {
            this.logger.warn(this.appendContextMessage(msg));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        if (disabled || !this.logger.isWarnEnabled()) {
            return;
        }
        try {
            this.logger.warn(this.appendContextMessage(msg), arguments);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void error(String msg, Throwable e) {
        if (disabled || !this.logger.isErrorEnabled()) {
            return;
        }
        try {
            this.logger.error(this.appendContextMessage(msg), e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void error(String msg) {
        if (disabled || !this.logger.isErrorEnabled()) {
            return;
        }
        try {
            this.logger.error(this.appendContextMessage(msg));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void error(String msg, Object ... arguments) {
        if (disabled || !this.logger.isErrorEnabled()) {
            return;
        }
        try {
            this.logger.error(this.appendContextMessage(msg), arguments);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void error(Throwable e) {
        if (disabled || !this.logger.isErrorEnabled()) {
            return;
        }
        try {
            this.logger.error(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void info(Throwable e) {
        if (disabled || !this.logger.isInfoEnabled()) {
            return;
        }
        try {
            this.logger.info(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void warn(Throwable e) {
        if (disabled || !this.logger.isWarnEnabled()) {
            return;
        }
        try {
            this.logger.warn(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isTraceEnabled() {
        if (disabled) {
            return false;
        }
        try {
            return this.logger.isTraceEnabled();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Override
    public boolean isDebugEnabled() {
        if (disabled) {
            return false;
        }
        try {
            return this.logger.isDebugEnabled();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Override
    public boolean isInfoEnabled() {
        if (disabled) {
            return false;
        }
        try {
            return this.logger.isInfoEnabled();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Override
    public boolean isWarnEnabled() {
        if (disabled) {
            return false;
        }
        try {
            return this.logger.isWarnEnabled();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Override
    public boolean isErrorEnabled() {
        if (disabled) {
            return false;
        }
        try {
            return this.logger.isErrorEnabled();
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

