/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class StreamUtils {
    public static final ByteArrayInputStream EMPTY = new ByteArrayInputStream(new byte[0]);

    private StreamUtils() {
    }

    public static InputStream limitedInputStream(final InputStream is, final int limit) throws IOException {
        return new InputStream(){
            private int mPosition = 0;
            private int mMark = 0;
            private final int mLimit = Math.min(limit, is.available());

            @Override
            public int read() throws IOException {
                if (this.mPosition < this.mLimit) {
                    ++this.mPosition;
                    return is.read();
                }
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || len < 0 || len > b.length - off) {
                    throw new IndexOutOfBoundsException();
                }
                if (this.mPosition >= this.mLimit) {
                    return -1;
                }
                if (this.mPosition + len > this.mLimit) {
                    len = this.mLimit - this.mPosition;
                }
                if (len <= 0) {
                    return 0;
                }
                is.read(b, off, len);
                this.mPosition += len;
                return len;
            }

            @Override
            public long skip(long len) throws IOException {
                if ((long)this.mPosition + len > (long)this.mLimit) {
                    len = this.mLimit - this.mPosition;
                }
                if (len <= 0L) {
                    return 0L;
                }
                is.skip(len);
                this.mPosition = (int)((long)this.mPosition + len);
                return len;
            }

            @Override
            public int available() {
                return this.mLimit - this.mPosition;
            }

            @Override
            public boolean markSupported() {
                return is.markSupported();
            }

            @Override
            public synchronized void mark(int readlimit) {
                is.mark(readlimit);
                this.mMark = this.mPosition;
            }

            @Override
            public synchronized void reset() throws IOException {
                is.reset();
                this.mPosition = this.mMark;
            }

            @Override
            public void close() throws IOException {
                is.close();
            }
        };
    }

    public static InputStream markSupportedInputStream(final InputStream is, final int markBufferSize) {
        if (is.markSupported()) {
            return is;
        }
        return new InputStream(){
            byte[] mMarkBuffer;
            boolean mInMarked = false;
            boolean mInReset = false;
            boolean mDry = false;
            private int mPosition = 0;
            private int mCount = 0;

            @Override
            public int read() throws IOException {
                if (!this.mInMarked) {
                    return is.read();
                }
                if (this.mPosition < this.mCount) {
                    byte b = this.mMarkBuffer[this.mPosition++];
                    return b & 0xFF;
                }
                if (!this.mInReset) {
                    if (this.mDry) {
                        return -1;
                    }
                    if (null == this.mMarkBuffer) {
                        this.mMarkBuffer = new byte[markBufferSize];
                    }
                    if (this.mPosition >= markBufferSize) {
                        throw new IOException("Mark buffer is full!");
                    }
                    int read = is.read();
                    if (-1 == read) {
                        this.mDry = true;
                        return -1;
                    }
                    this.mMarkBuffer[this.mPosition++] = (byte)read;
                    ++this.mCount;
                    return read;
                }
                this.mInMarked = false;
                this.mInReset = false;
                this.mPosition = 0;
                this.mCount = 0;
                return is.read();
            }

            @Override
            public synchronized void mark(int readlimit) {
                this.mInMarked = true;
                this.mInReset = false;
                int count = this.mCount - this.mPosition;
                if (count > 0) {
                    System.arraycopy(this.mMarkBuffer, this.mPosition, this.mMarkBuffer, 0, count);
                    this.mCount = count;
                    this.mPosition = 0;
                }
            }

            @Override
            public synchronized void reset() throws IOException {
                if (!this.mInMarked) {
                    throw new IOException("should mark before reset!");
                }
                this.mInReset = true;
                this.mPosition = 0;
            }

            @Override
            public boolean markSupported() {
                return true;
            }

            @Override
            public int available() throws IOException {
                int available = is.available();
                if (this.mInMarked && this.mInReset) {
                    available += this.mCount - this.mPosition;
                }
                return available;
            }

            @Override
            public void close() throws IOException {
                is.close();
            }
        };
    }

    public static InputStream markSupportedInputStream(InputStream is) {
        return StreamUtils.markSupportedInputStream(is, 1024);
    }

    public static void skipUnusedStream(InputStream is) throws IOException {
        if (is.available() > 0) {
            is.skip(is.available());
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        if (in.getClass() == ByteArrayInputStream.class) {
            StreamUtils.copy((ByteArrayInputStream)in, out);
            return;
        }
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static void copy(ByteArrayInputStream in, OutputStream out) throws IOException {
        int len = in.available();
        byte[] buffer = new byte[len];
        in.read(buffer, 0, len);
        out.write(buffer, 0, len);
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        int bytesRead;
        if (in.getClass() == ByteArrayInputStream.class) {
            return StreamUtils.readBytes((ByteArrayInputStream)in);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        return out.toByteArray();
    }

    public static byte[] readBytes(ByteArrayInputStream in) throws IOException {
        int len = in.available();
        byte[] bytes = new byte[len];
        in.read(bytes, 0, len);
        return bytes;
    }

    public static String toString(InputStream in) throws IOException {
        return new String(StreamUtils.readBytes(in), StandardCharsets.UTF_8);
    }

    public static String toString(InputStream in, Charset charset) throws IOException {
        return new String(StreamUtils.readBytes(in), charset);
    }
}

