/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import org.apache.dubbo.common.utils.ReflectUtils;

public class MethodDescriptor {
    private final Method method;
    private final String paramDesc;
    private final String[] compatibleParamSignatures;
    private final Class<?>[] parameterClasses;
    private final Class<?> returnClass;
    private final Type[] returnTypes;
    private final String methodName;
    private final boolean generic;

    public MethodDescriptor(Method method) {
        this.method = method;
        this.parameterClasses = method.getParameterTypes();
        this.returnClass = method.getReturnType();
        this.returnTypes = ReflectUtils.getReturnTypes(method);
        this.paramDesc = ReflectUtils.getDesc(this.parameterClasses);
        this.compatibleParamSignatures = (String[])Stream.of(this.parameterClasses).map(Class::getName).toArray(String[]::new);
        this.methodName = method.getName();
        this.generic = (this.methodName.equals("$invoke") || this.methodName.equals("$invokeAsync")) && this.parameterClasses.length == 3;
    }

    public boolean matchParams(String params) {
        return this.paramDesc.equalsIgnoreCase(params);
    }

    public Method getMethod() {
        return this.method;
    }

    public String getParamDesc() {
        return this.paramDesc;
    }

    public String[] getCompatibleParamSignatures() {
        return this.compatibleParamSignatures;
    }

    public Class<?>[] getParameterClasses() {
        return this.parameterClasses;
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    public Type[] getReturnTypes() {
        return this.returnTypes;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isGeneric() {
        return this.generic;
    }
}

