/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractReferenceConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public abstract class ReferenceConfigBase<T>
extends AbstractReferenceConfig {
    private static final long serialVersionUID = -5864351140409987595L;
    protected Class<?> interfaceClass;
    protected String client;
    protected String url;
    protected ConsumerConfig consumer;
    protected String protocol;

    public ReferenceConfigBase() {
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute("ORIGIN_CONFIG", this);
    }

    public ReferenceConfigBase(Reference reference) {
        this.serviceMetadata = new ServiceMetadata();
        this.serviceMetadata.addAttribute("ORIGIN_CONFIG", this);
        this.appendAnnotation(Reference.class, reference);
        this.setMethods(MethodConfig.constructMethodConfig(reference.methods()));
    }

    public boolean shouldCheck() {
        Boolean shouldCheck = this.isCheck();
        if (shouldCheck == null && this.getConsumer() != null) {
            shouldCheck = this.getConsumer().isCheck();
        }
        if (shouldCheck == null) {
            shouldCheck = true;
        }
        return shouldCheck;
    }

    public boolean shouldInit() {
        Boolean shouldInit = this.isInit();
        if (shouldInit == null && this.getConsumer() != null) {
            shouldInit = this.getConsumer().isInit();
        }
        if (shouldInit == null) {
            return true;
        }
        return shouldInit;
    }

    public void checkDefault() throws IllegalStateException {
        if (this.consumer == null) {
            this.consumer = ApplicationModel.getConfigManager().getDefaultConsumer().orElse(new ConsumerConfig());
        }
    }

    public Class<?> getActualInterface() {
        Class<?> actualInterface = this.interfaceClass;
        if (this.interfaceClass == GenericService.class) {
            try {
                actualInterface = Class.forName(this.interfaceName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return actualInterface;
    }

    public Class<?> getInterfaceClass() {
        if (this.interfaceClass != null) {
            return this.interfaceClass;
        }
        if (ProtocolUtils.isGeneric(this.getGeneric()) || this.getConsumer() != null && ProtocolUtils.isGeneric(this.getConsumer().getGeneric())) {
            return GenericService.class;
        }
        try {
            if (this.interfaceName != null && this.interfaceName.length() > 0) {
                this.interfaceClass = Class.forName(this.interfaceName, true, ClassUtils.getClassLoader());
            }
        }
        catch (ClassNotFoundException t) {
            throw new IllegalStateException(t.getMessage(), t);
        }
        return this.interfaceClass;
    }

    @Deprecated
    public void setInterfaceClass(Class<?> interfaceClass) {
        this.setInterface(interfaceClass);
    }

    public void setInterface(Class<?> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.interfaceClass = interfaceClass;
        this.setInterface(interfaceClass == null ? null : interfaceClass.getName());
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    @Parameter(excluded=true)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ConsumerConfig getConsumer() {
        return this.consumer;
    }

    public void setConsumer(ConsumerConfig consumer) {
        this.consumer = consumer;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    @Override
    @Parameter(excluded=true)
    public String getPrefix() {
        return "dubbo.reference." + this.interfaceName;
    }

    public void resolveFile() {
        String resolve = System.getProperty(this.interfaceName);
        String resolveFile = null;
        if (StringUtils.isEmpty(resolve)) {
            File userResolveFile;
            resolveFile = System.getProperty("dubbo.resolve.file");
            if (StringUtils.isEmpty(resolveFile) && (userResolveFile = new File(new File(System.getProperty("user.home")), "dubbo-resolve.properties")).exists()) {
                resolveFile = userResolveFile.getAbsolutePath();
            }
            if (resolveFile != null && resolveFile.length() > 0) {
                Properties properties = new Properties();
                try (FileInputStream fis = new FileInputStream(new File(resolveFile));){
                    properties.load(fis);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load " + resolveFile + ", cause: " + e.getMessage(), e);
                }
                resolve = properties.getProperty(this.interfaceName);
            }
        }
        if (resolve != null && resolve.length() > 0) {
            this.url = resolve;
            if (logger.isWarnEnabled()) {
                if (resolveFile != null) {
                    logger.warn("Using default dubbo resolve file " + resolveFile + " replace " + this.interfaceName + "" + resolve + " to p2p invoke remote service.");
                } else {
                    logger.warn("Using -D" + this.interfaceName + "=" + resolve + " to p2p invoke remote service.");
                }
            }
        }
    }

    @Override
    protected void computeValidRegistryIds() {
        if (this.consumer != null && this.notHasSelfRegistryProperty()) {
            this.setRegistries(this.consumer.getRegistries());
            this.setRegistryIds(this.consumer.getRegistryIds());
        }
        super.computeValidRegistryIds();
    }

    @Parameter(excluded=true)
    public String getUniqueServiceName() {
        return URL.buildKey(this.interfaceName, this.getGroup(), this.getVersion());
    }

    @Override
    public String getVersion() {
        return StringUtils.isEmpty(this.version) ? (this.consumer != null ? this.consumer.getVersion() : this.version) : this.version;
    }

    @Override
    public String getGroup() {
        return StringUtils.isEmpty(this.group) ? (this.consumer != null ? this.consumer.getGroup() : this.group) : this.group;
    }

    public abstract T get();

    public abstract void destroy();
}

