/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.Timeout;
import org.apache.dubbo.common.timer.Timer;
import org.apache.dubbo.common.timer.TimerTask;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;
import org.apache.dubbo.rpc.support.RpcUtils;

public class FailbackClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(FailbackClusterInvoker.class);
    private static final long RETRY_FAILED_PERIOD = 5L;
    private final int retries;
    private final int failbackTasks;
    private volatile Timer failTimer;

    public FailbackClusterInvoker(Directory<T> directory) {
        super(directory);
        int failbackTasksConfig;
        int retriesConfig = this.getUrl().getParameter("retries", 3);
        if (retriesConfig < 0) {
            retriesConfig = 3;
        }
        if ((failbackTasksConfig = this.getUrl().getParameter("failbacktasks", 100)) <= 0) {
            failbackTasksConfig = 100;
        }
        this.retries = retriesConfig;
        this.failbackTasks = failbackTasksConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFailed(LoadBalance loadbalance, Invocation invocation, List<Invoker<T>> invokers, Invoker<T> lastInvoker, URL consumerUrl) {
        if (this.failTimer == null) {
            FailbackClusterInvoker failbackClusterInvoker = this;
            synchronized (failbackClusterInvoker) {
                if (this.failTimer == null) {
                    this.failTimer = new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("failback-cluster-timer", true), 1L, TimeUnit.SECONDS, 32, (long)this.failbackTasks);
                }
            }
        }
        RetryTimerTask retryTimerTask = new RetryTimerTask(loadbalance, invocation, invokers, lastInvoker, this.retries, 5L, consumerUrl);
        try {
            this.failTimer.newTimeout((TimerTask)retryTimerTask, 5L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            logger.error("2-9", "add newTimeout exception", "", "Failback background works error, invocation->" + invocation + ", exception: " + e.getMessage(), e);
        }
    }

    @Override
    protected Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        Invoker<T> invoker = null;
        URL consumerUrl = RpcContext.getServiceContext().getConsumerUrl();
        try {
            invoker = this.select(loadbalance, invocation, invokers, null);
            return this.invokeWithContextAsync(invoker, invocation, consumerUrl);
        }
        catch (Throwable e) {
            logger.error("2-10", "Failback to invoke method and start to retries", "", "Failback to invoke method " + RpcUtils.getMethodName((Invocation)invocation) + ", wait for retry in background. Ignored exception: " + e.getMessage() + ", ", e);
            if (this.retries > 0) {
                this.addFailed(loadbalance, invocation, invokers, invoker, consumerUrl);
            }
            return AsyncRpcResult.newDefaultAsyncResult(null, null, (Invocation)invocation);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.failTimer != null) {
            this.failTimer.stop();
        }
    }

    private class RetryTimerTask
    implements TimerTask {
        private final Invocation invocation;
        private final LoadBalance loadbalance;
        private final List<Invoker<T>> invokers;
        private final long tick;
        private Invoker<T> lastInvoker;
        private URL consumerUrl;
        private final int retries;
        private int retriedTimes = 0;

        RetryTimerTask(LoadBalance loadbalance, Invocation invocation, List<Invoker<T>> invokers, Invoker<T> lastInvoker, int retries, long tick, URL consumerUrl) {
            this.loadbalance = loadbalance;
            this.invocation = invocation;
            this.invokers = invokers;
            this.retries = retries;
            this.tick = tick;
            this.lastInvoker = lastInvoker;
            this.consumerUrl = consumerUrl;
        }

        public void run(Timeout timeout) {
            try {
                logger.info("Attempt to retry to invoke method " + RpcUtils.getMethodName((Invocation)this.invocation) + ". The total will retry " + this.retries + " times, the current is the " + this.retriedTimes + " retry");
                Invoker retryInvoker = FailbackClusterInvoker.this.select(this.loadbalance, this.invocation, this.invokers, Collections.singletonList(this.lastInvoker));
                this.lastInvoker = retryInvoker;
                FailbackClusterInvoker.this.invokeWithContextAsync(retryInvoker, this.invocation, this.consumerUrl);
            }
            catch (Throwable e) {
                logger.error("2-10", "Failed retry to invoke method", "", "Failed retry to invoke method " + RpcUtils.getMethodName((Invocation)this.invocation) + ", waiting again.", e);
                if (++this.retriedTimes >= this.retries) {
                    logger.error("2-10", "Failed retry to invoke method and retry times exceed threshold", "", "Failed retry times exceed threshold (" + this.retries + "), We have to abandon, invocation->" + this.invocation, e);
                }
                this.rePut(timeout);
            }
        }

        private void rePut(Timeout timeout) {
            if (timeout == null) {
                return;
            }
            Timer timer = timeout.timer();
            if (timer.isStop() || timeout.isCancelled()) {
                return;
            }
            timer.newTimeout(timeout.task(), this.tick, TimeUnit.SECONDS);
        }
    }
}

