/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.affinity.config.model;

import java.util.Map;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.cluster.router.AbstractRouterRule;

public class AffinityRouterRule
extends AbstractRouterRule {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AffinityRouterRule.class);
    private String affinityKey;
    private Double ratio;

    public static AffinityRouterRule parseFromMap(Map<String, Object> map) {
        AffinityRouterRule affinityRouterRule = new AffinityRouterRule();
        affinityRouterRule.parseFromMap0(map);
        Object conditions = map.get("affinityAware");
        Map conditionMap = (Map)conditions;
        affinityRouterRule.setAffinityKey((String)conditionMap.get("key"));
        String ratio = conditionMap.getOrDefault("ratio", String.valueOf(0.0));
        affinityRouterRule.setRatio(Double.valueOf(String.valueOf(ratio)));
        if (affinityRouterRule.getRatio() > 100.0 || affinityRouterRule.getRatio() < 0.0) {
            logger.error("2-15", "Invalid affinity router config.", "", "The ratio value must range from 0 to 100");
            affinityRouterRule.setValid(false);
        }
        return affinityRouterRule;
    }

    public String getAffinityKey() {
        return this.affinityKey;
    }

    public void setAffinityKey(String affinityKey) {
        this.affinityKey = affinityKey;
    }

    public Double getRatio() {
        return this.ratio;
    }

    public void setRatio(Double ratio) {
        this.ratio = ratio;
    }
}

