/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.affinity.config;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.Holder;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.AbstractRouterRule;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotNode;
import org.apache.dubbo.rpc.cluster.router.affinity.AffinityStateRouter;
import org.apache.dubbo.rpc.cluster.router.affinity.config.model.AffinityRouterRule;
import org.apache.dubbo.rpc.cluster.router.affinity.config.model.AffinityRuleParser;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.TailStateRouter;

public abstract class AffinityListenableStateRouter<T>
extends AbstractStateRouter<T>
implements ConfigurationListener {
    public static final String NAME = "Affinity_LISTENABLE_ROUTER";
    public static final String RULE_SUFFIX = ".affinity-router";
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AffinityListenableStateRouter.class);
    private volatile AffinityRouterRule affinityRouterRule;
    private volatile AffinityStateRouter<T> affinityRouter;
    private final String ruleKey;

    public AffinityListenableStateRouter(URL url, String ruleKey) {
        super(url);
        this.setForce(false);
        this.init(ruleKey);
        this.ruleKey = ruleKey;
    }

    public synchronized void process(ConfigChangedEvent event) {
        if (logger.isInfoEnabled()) {
            logger.info("Notification of affinity rule, change type is: " + event.getChangeType() + ", raw rule is:\n " + event.getContent());
        }
        if (event.getChangeType().equals((Object)ConfigChangeType.DELETED)) {
            this.affinityRouterRule = null;
            this.affinityRouter = null;
        } else {
            try {
                this.affinityRouterRule = AffinityRuleParser.parse(event.getContent());
                this.generateConditions(this.affinityRouterRule);
            }
            catch (Exception e) {
                logger.error("2-15", "Failed to parse the raw affinity rule", "", "Failed to parse the raw affinity rule and it will not take effect, please check if the affinity rule matches with the template, the raw rule is:\n " + event.getContent(), (Throwable)e);
            }
        }
    }

    @Override
    public BitList<Invoker<T>> doRoute(BitList<Invoker<T>> invokers, URL url, Invocation invocation, boolean needToPrintMessage, Holder<RouterSnapshotNode<T>> nodeHolder, Holder<String> messageHolder) throws RpcException {
        if (CollectionUtils.isEmpty(invokers) || this.affinityRouter == null) {
            if (needToPrintMessage) {
                messageHolder.set((Object)"Directly return. Reason: Invokers from previous router is empty or affinityRouter is null.");
            }
            return invokers;
        }
        StringBuilder resultMessage = null;
        if (needToPrintMessage) {
            resultMessage = new StringBuilder();
        }
        invokers = this.affinityRouter.route(invokers, url, invocation, needToPrintMessage, nodeHolder);
        if (needToPrintMessage) {
            resultMessage.append((String)messageHolder.get());
        }
        if (needToPrintMessage) {
            messageHolder.set((Object)resultMessage.toString());
        }
        return invokers;
    }

    @Override
    public boolean isForce() {
        return this.affinityRouterRule != null && this.affinityRouterRule.isForce();
    }

    private boolean isRuleRuntime() {
        return this.affinityRouterRule != null && this.affinityRouterRule.isValid() && this.affinityRouterRule.isRuntime();
    }

    private void generateConditions(AbstractRouterRule rule) {
        if (rule == null || !rule.isValid()) {
            return;
        }
        AffinityRouterRule affinityRule = (AffinityRouterRule)rule;
        this.affinityRouter = new AffinityStateRouter(this.getUrl(), affinityRule.getAffinityKey(), affinityRule.getRatio(), affinityRule.isEnabled());
        this.affinityRouter.setNextRouter(TailStateRouter.getInstance());
    }

    private synchronized void init(String ruleKey) {
        if (StringUtils.isEmpty((String)ruleKey)) {
            return;
        }
        String routerKey = ruleKey + RULE_SUFFIX;
        this.getRuleRepository().addListener(routerKey, this);
        String rule = this.getRuleRepository().getRule(routerKey, "dubbo");
        if (StringUtils.isNotEmpty((String)rule)) {
            this.process(new ConfigChangedEvent(routerKey, "dubbo", rule));
        }
    }

    public AffinityStateRouter<T> getAffinityRouter() {
        return this.affinityRouter;
    }

    @Override
    public void stop() {
        this.getRuleRepository().removeListener(this.ruleKey + RULE_SUFFIX, this);
    }
}

