/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.condition.matcher.attachment;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.cluster.router.condition.matcher.AbstractConditionMatcher;
import org.apache.dubbo.rpc.model.ModuleModel;

@Activate
public class AttachmentConditionMatcher
extends AbstractConditionMatcher {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AttachmentConditionMatcher.class);
    private static final Pattern ATTACHMENTS_PATTERN = Pattern.compile("attachments\\[(.+)\\]");

    public AttachmentConditionMatcher(String key, ModuleModel model) {
        super(key, model);
    }

    @Override
    protected String getValue(Map<String, String> sample, URL url, Invocation invocation) {
        try {
            String[] expressArray = this.key.split("\\.");
            String argumentExpress = expressArray[0];
            Matcher matcher = ATTACHMENTS_PATTERN.matcher(argumentExpress);
            if (!matcher.find()) {
                return "dubbo_internal_not_found_argument_condition_value";
            }
            String attachmentKey = matcher.group(1);
            if (StringUtils.isEmpty((String)attachmentKey)) {
                return "dubbo_internal_not_found_argument_condition_value";
            }
            return invocation.getAttachment(attachmentKey);
        }
        catch (Exception e) {
            logger.warn("2-7", "condition state router attachment match failed", "", "Invalid match condition: " + this.key, (Throwable)e);
            return "dubbo_internal_not_found_argument_condition_value";
        }
    }
}

