/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter.support;

import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PenetrateAttachmentSelector;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcContextAttachment;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TimeoutCountDown;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate(group={"consumer"}, order=-2147483648)
public class ConsumerContextFilter
implements ClusterFilter,
BaseFilter.Listener {
    private ApplicationModel applicationModel;
    private Set<PenetrateAttachmentSelector> supportedSelectors;

    public ConsumerContextFilter(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        ExtensionLoader selectorExtensionLoader = applicationModel.getExtensionLoader(PenetrateAttachmentSelector.class);
        this.supportedSelectors = selectorExtensionLoader.getSupportedExtensionInstances();
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        TimeoutCountDown timeoutCountDown;
        Object countDown;
        RpcContext.getServiceContext().setInvoker(invoker).setInvocation(invocation).setLocalAddress(NetUtils.getLocalHost(), 0);
        RpcContextAttachment context = RpcContext.getClientAttachment();
        context.setAttachment("remote.application", invoker.getUrl().getApplication());
        if (invocation instanceof RpcInvocation) {
            ((RpcInvocation)invocation).setInvoker(invoker);
        }
        if (CollectionUtils.isNotEmpty(this.supportedSelectors)) {
            for (PenetrateAttachmentSelector supportedSelector : this.supportedSelectors) {
                Map selected = supportedSelector.select();
                if (!CollectionUtils.isNotEmptyMap((Map)selected)) continue;
                ((RpcInvocation)invocation).addObjectAttachments(selected);
            }
        } else {
            ((RpcInvocation)invocation).addObjectAttachments(RpcContext.getServerAttachment().getObjectAttachments());
        }
        Map contextAttachments = RpcContext.getClientAttachment().getObjectAttachments();
        if (CollectionUtils.isNotEmptyMap((Map)contextAttachments)) {
            ((RpcInvocation)invocation).addObjectAttachments(contextAttachments);
        }
        if ((countDown = context.getObjectAttachment("timeout-countdown")) != null && (timeoutCountDown = (TimeoutCountDown)countDown).isExpired()) {
            return AsyncRpcResult.newDefaultAsyncResult((Throwable)new RpcException(8, "No time left for making the following call: " + invocation.getServiceName() + "." + invocation.getMethodName() + ", terminate directly."), (Invocation)invocation);
        }
        RpcContext.removeServerContext();
        return invoker.invoke(invocation);
    }

    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        RpcContext.getServerContext().setObjectAttachments(appResponse.getObjectAttachments());
        this.removeContext();
    }

    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        this.removeContext();
    }

    private void removeContext() {
        RpcContext.removeServiceContext();
        RpcContext.removeClientAttachment();
    }
}

