/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotSwitcher;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Activate(group={"consumer"})
public class RouterSnapshotFilter
implements ClusterFilter,
BaseFilter.Listener {
    private final RouterSnapshotSwitcher switcher;
    private static final Logger logger = LoggerFactory.getLogger(RouterSnapshotFilter.class);

    public RouterSnapshotFilter(FrameworkModel frameworkModel) {
        this.switcher = (RouterSnapshotSwitcher)frameworkModel.getBeanFactory().getBean(RouterSnapshotSwitcher.class);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (!this.switcher.isEnable()) {
            return invoker.invoke(invocation);
        }
        if (!logger.isInfoEnabled()) {
            return invoker.invoke(invocation);
        }
        if (!this.switcher.isEnable(invocation.getServiceModel().getServiceKey())) {
            return invoker.invoke(invocation);
        }
        RpcContext.getServiceContext().setNeedPrintRouterSnapshot(true);
        return invoker.invoke(invocation);
    }

    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        RpcContext.getServiceContext().setNeedPrintRouterSnapshot(false);
    }

    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        RpcContext.getServiceContext().setNeedPrintRouterSnapshot(false);
    }
}

