/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match;

public class StringMatch {
    private String exact;
    private String prefix;
    private String regex;
    private String noempty;
    private String empty;

    public String getExact() {
        return this.exact;
    }

    public void setExact(String exact) {
        this.exact = exact;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getNoempty() {
        return this.noempty;
    }

    public void setNoempty(String noempty) {
        this.noempty = noempty;
    }

    public String getEmpty() {
        return this.empty;
    }

    public void setEmpty(String empty) {
        this.empty = empty;
    }

    public static boolean isMatch(StringMatch stringMatch, String input) {
        if (stringMatch.getExact() != null && input != null) {
            if (input.equals(stringMatch.getExact())) {
                return true;
            }
        } else if (stringMatch.getPrefix() != null && input != null) {
            if (input.startsWith(stringMatch.getPrefix())) {
                return true;
            }
        } else if (stringMatch.getRegex() != null && input != null) {
            if (input.matches(stringMatch.getRegex())) {
                return true;
            }
        } else {
            if (stringMatch.getEmpty() != null) {
                return input == null || "".equals(input);
            }
            if (stringMatch.getNoempty() != null) {
                return input != null && input.length() > 0;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return "StringMatch{exact='" + this.exact + '\'' + ", prefix='" + this.prefix + '\'' + ", regex='" + this.regex + '\'' + ", noempty='" + this.noempty + '\'' + ", empty='" + this.empty + '\'' + '}';
    }
}

