/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;

public interface Router
extends Comparable<Router> {
    public static final int DEFAULT_PRIORITY = Integer.MAX_VALUE;

    public URL getUrl();

    public <T> List<Invoker<T>> route(List<Invoker<T>> var1, URL var2, Invocation var3) throws RpcException;

    default public <T> void notify(List<Invoker<T>> invokers) {
    }

    public boolean isRuntime();

    public boolean isForce();

    public int getPriority();

    default public void stop() {
    }

    @Override
    default public int compareTo(Router o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        return Integer.compare(this.getPriority(), o.getPriority());
    }
}

