/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.router.state.AbstractStateRouter;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.RouterCache;
import org.apache.dubbo.rpc.cluster.router.tag.model.TagRouterRule;

public class TagStaticStateRouter
extends AbstractStateRouter {
    public static final String NAME = "TAG_ROUTER";
    private static final int TAG_ROUTER_DEFAULT_PRIORITY = 100;
    private static final Logger logger = LoggerFactory.getLogger(TagStaticStateRouter.class);
    private static final String NO_TAG = "noTag";
    private TagRouterRule tagRouterRule;

    public TagStaticStateRouter(URL url, RouterChain chain) {
        super(url, chain);
        this.priority = 100;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public <T> BitList<Invoker<T>> route(BitList<Invoker<T>> invokers, RouterCache<T> routerCache, URL url, Invocation invocation) throws RpcException {
        ConcurrentMap<String, BitList<Invoker<T>>> pool;
        BitList res;
        String tag;
        String string = tag = StringUtils.isEmpty((String)invocation.getAttachment("dubbo.tag")) ? url.getParameter("dubbo.tag") : invocation.getAttachment("dubbo.tag");
        if (StringUtils.isEmpty((String)tag)) {
            tag = NO_TAG;
        }
        if ((res = (BitList)(pool = routerCache.getAddrPool()).get(tag)) == null) {
            return invokers;
        }
        return invokers.intersect(res, invokers.getUnmodifiableList());
    }

    @Override
    protected List<String> getTags(URL url, Invocation invocation) {
        String tag;
        ArrayList<String> tags = new ArrayList<String>();
        String string = tag = StringUtils.isEmpty((String)invocation.getAttachment("dubbo.tag")) ? url.getParameter("dubbo.tag") : invocation.getAttachment("dubbo.tag");
        if (StringUtils.isEmpty((String)tag)) {
            tag = NO_TAG;
        }
        tags.add(tag);
        return tags;
    }

    @Override
    public boolean isRuntime() {
        return this.tagRouterRule != null && this.tagRouterRule.isRuntime();
    }

    @Override
    public boolean isEnable() {
        return true;
    }

    @Override
    public boolean isForce() {
        return false;
    }

    @Override
    public String getName() {
        return "TagStatic";
    }

    @Override
    public boolean shouldRePool() {
        return false;
    }

    @Override
    public <T> RouterCache<T> pool(List<Invoker<T>> invokers) {
        RouterCache routerCache = new RouterCache();
        ConcurrentHashMap addrPool = new ConcurrentHashMap();
        for (int index = 0; index < invokers.size(); ++index) {
            Invoker<T> invoker = invokers.get(index);
            String tag = invoker.getUrl().getParameter("dubbo.tag");
            if (StringUtils.isEmpty((String)tag)) {
                BitList<Invoker<T>> noTagList = addrPool.putIfAbsent(NO_TAG, new BitList<Invoker<T>>(invokers, true));
                if (noTagList == null) {
                    noTagList = addrPool.get(NO_TAG);
                }
                noTagList.addIndex(index);
                continue;
            }
            BitList<Invoker<T>> list = addrPool.putIfAbsent(tag, new BitList<Invoker<T>>(invokers, true));
            if (list == null) {
                list = addrPool.get(tag);
            }
            list.addIndex(index);
        }
        routerCache.setAddrPool(addrPool);
        return routerCache;
    }

    @Override
    public <T> void notify(List<Invoker<T>> invokers) {
        if (CollectionUtils.isEmpty(invokers)) {
            return;
        }
        this.pool(invokers);
    }
}

