/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.state;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.state.BitList;
import org.apache.dubbo.rpc.cluster.router.state.RouterCache;

public interface StateRouter
extends Comparable<StateRouter> {
    public static final int DEFAULT_PRIORITY = Integer.MAX_VALUE;

    public URL getUrl();

    public <T> BitList<Invoker<T>> route(BitList<Invoker<T>> var1, RouterCache<T> var2, URL var3, Invocation var4) throws RpcException;

    default public <T> void notify(List<Invoker<T>> invokers) {
    }

    public boolean isRuntime();

    public boolean isEnable();

    public boolean isForce();

    public int getPriority();

    @Override
    default public int compareTo(StateRouter o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        return Integer.compare(this.getPriority(), o.getPriority());
    }

    public String getName();

    public boolean shouldRePool();

    public <T> RouterCache<T> pool(List<Invoker<T>> var1);

    public void pool();

    default public void stop() {
    }
}

