/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice;

import java.util.Map;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.DoubleMatch;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.DubboAttachmentMatch;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.DubboMethodMatch;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.StringMatch;

public class DubboMatchRequest {
    private String name;
    private DubboMethodMatch method;
    private Map<String, String> sourceLabels;
    private DubboAttachmentMatch attachments;
    private Map<String, StringMatch> headers;
    private DoubleMatch threshold;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DubboMethodMatch getMethod() {
        return this.method;
    }

    public void setMethod(DubboMethodMatch method) {
        this.method = method;
    }

    public Map<String, String> getSourceLabels() {
        return this.sourceLabels;
    }

    public void setSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels;
    }

    public DubboAttachmentMatch getAttachments() {
        return this.attachments;
    }

    public void setAttachments(DubboAttachmentMatch attachments) {
        this.attachments = attachments;
    }

    public Map<String, StringMatch> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, StringMatch> headers) {
        this.headers = headers;
    }

    public DoubleMatch getThreshold() {
        return this.threshold;
    }

    public void setThreshold(DoubleMatch threshold) {
        this.threshold = threshold;
    }

    public static boolean isMatch(DubboMatchRequest dubboMatchRequest, String methodName, String[] parameterTypeList, Object[] parameters, Map<String, String> sourceLabels, Map<String, String> eagleeyeContext, Map<String, String> dubboContext, Map<String, String> headers) {
        if (dubboMatchRequest.getMethod() != null && !DubboMethodMatch.isMatch(dubboMatchRequest.getMethod(), methodName, parameterTypeList, parameters)) {
            return false;
        }
        if (dubboMatchRequest.getSourceLabels() != null) {
            for (Map.Entry<String, String> entry : dubboMatchRequest.getSourceLabels().entrySet()) {
                String value = sourceLabels.get(entry.getKey());
                if (value != null && entry.getValue().equals(value)) continue;
                return false;
            }
        }
        return dubboMatchRequest.getAttachments() == null || DubboAttachmentMatch.isMatch(dubboMatchRequest.getAttachments(), eagleeyeContext, dubboContext);
    }

    public String toString() {
        return "DubboMatchRequest{name='" + this.name + '\'' + ", method=" + this.method + ", sourceLabels=" + this.sourceLabels + ", attachments=" + this.attachments + ", headers=" + this.headers + ", threshold=" + this.threshold + '}';
    }
}

