/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.FilterChainBuilder;

@Activate(order=100)
public class ProtocolFilterWrapper
implements Protocol {
    private final Protocol protocol;
    private static final FilterChainBuilder builder = (FilterChainBuilder)ExtensionLoader.getExtensionLoader(FilterChainBuilder.class).getDefaultExtension();

    public ProtocolFilterWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        if (UrlUtils.isRegistry((URL)invoker.getUrl())) {
            return this.protocol.export(invoker);
        }
        return this.protocol.export(builder.buildInvokerChain(invoker, "service.filter", "provider"));
    }

    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        if (UrlUtils.isRegistry((URL)url)) {
            return this.protocol.refer(type, url);
        }
        return builder.buildInvokerChain(this.protocol.refer(type, url), "reference.filter", "consumer");
    }

    public void destroy() {
        this.protocol.destroy();
    }

    public List<ProtocolServer> getServers() {
        return this.protocol.getServers();
    }
}

